/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class JumpFOperation
extends AbstractOperation {
    public static final int OPCODE = 229;
    static final Operation.OperationResult jumpfSuccess = new Operation.OperationResult(3L, null);

    public JumpFOperation(GasCalculator gasCalculator) {
        super(229, "JUMPF", 0, 0, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        byte[] code = frame.getCode().getBytes().toArrayUnsafe();
        return JumpFOperation.staticOperation(frame, code, frame.getPC());
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame, byte[] code, int pc) {
        int section = Words.readBigEndianU16(pc + 1, code);
        ExceptionalHaltReason exception = frame.jumpFunction(section);
        if (exception == null) {
            return jumpfSuccess;
        }
        return new Operation.OperationResult(JumpFOperation.jumpfSuccess.gasCost, exception);
    }
}

