/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.token;

import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SingletonUsageProperties;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import com.hedera.node.app.hapi.fees.usage.token.entities.TokenEntitySizes;
import com.hedera.node.app.hapi.fees.usage.token.meta.ExtantFeeScheduleContext;
import com.hedera.node.app.hapi.fees.usage.token.meta.FeeScheduleUpdateMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenBurnMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenCreateMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenFreezeMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenMintMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenPauseMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnfreezeMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenUnpauseMeta;
import com.hedera.node.app.hapi.fees.usage.token.meta.TokenWipeMeta;
import com.hederahashgraph.api.proto.java.CustomFee;
import com.hederahashgraph.api.proto.java.RoyaltyFee;
import com.hederahashgraph.api.proto.java.SubType;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class TokenOpsUsage {
    private static final int FIXED_HBAR_REPR_SIZE = 8;
    private static final int FIXED_HTS_REPR_SIZE = 32;
    private static final int FRACTIONAL_REPR_SIZE = 32;
    private static final int ROYALTY_NO_FALLBACK_REPR_SIZE = 16;
    private static final int ROYALTY_HBAR_FALLBACK_REPR_SIZE = 24;
    private static final int ROYALTY_HTS_FALLBACK_REPR_SIZE = 48;
    public static final long LONG_BASIC_ENTITY_ID_SIZE = 24L;

    @Inject
    public TokenOpsUsage() {
    }

    public void feeScheduleUpdateUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, FeeScheduleUpdateMeta opMeta, ExtantFeeScheduleContext ctx, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(24L + (long)opMeta.numBytesInNewFeeScheduleRepr());
        long lifetime = Math.max(0L, ctx.expiry() - opMeta.effConsensusTime());
        long rbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage(ctx.numBytesInFeeScheduleRepr(), lifetime, opMeta.numBytesInNewFeeScheduleRepr(), lifetime);
        accumulator.addRbs(rbsDelta);
    }

    public int bytesNeededToRepr(List<CustomFee> feeSchedule) {
        int numFixedHbarFees = 0;
        int numFixedHtsFees = 0;
        int numFractionalFees = 0;
        int numRoyaltyNoFallbackFees = 0;
        int numRoyaltyHtsFallbackFees = 0;
        int numRoyaltyHbarFallbackFees = 0;
        for (CustomFee fee : feeSchedule) {
            if (fee.hasFixedFee()) {
                if (fee.getFixedFee().hasDenominatingTokenId()) {
                    ++numFixedHtsFees;
                    continue;
                }
                ++numFixedHbarFees;
                continue;
            }
            if (fee.hasFractionalFee()) {
                ++numFractionalFees;
                continue;
            }
            RoyaltyFee royaltyFee = fee.getRoyaltyFee();
            if (royaltyFee.hasFallbackFee()) {
                if (royaltyFee.getFallbackFee().hasDenominatingTokenId()) {
                    ++numRoyaltyHtsFallbackFees;
                    continue;
                }
                ++numRoyaltyHbarFallbackFees;
                continue;
            }
            ++numRoyaltyNoFallbackFees;
        }
        return this.bytesNeededToRepr(numFixedHbarFees, numFixedHtsFees, numFractionalFees, numRoyaltyNoFallbackFees, numRoyaltyHtsFallbackFees, numRoyaltyHbarFallbackFees);
    }

    public int bytesNeededToRepr(int numFixedHbarFees, int numFixedHtsFees, int numFractionalFees, int numRoyaltyNoFallbackFees, int numRoyaltyHtsFallbackFees, int numRoyaltyHbarFallbackFees) {
        return numFixedHbarFees * this.plusCollectorSize(8) + numFixedHtsFees * this.plusCollectorSize(32) + numFractionalFees * this.plusCollectorSize(32) + numRoyaltyNoFallbackFees * this.plusCollectorSize(16) + numRoyaltyHtsFallbackFees * this.plusCollectorSize(48) + numRoyaltyHbarFallbackFees * this.plusCollectorSize(24);
    }

    public void tokenCreateUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenCreateMeta tokenCreateMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenCreateMeta.getBaseSize());
        accumulator.addRbs((long)(tokenCreateMeta.getBaseSize() + tokenCreateMeta.getCustomFeeScheduleSize()) * tokenCreateMeta.getLifeTime());
        long tokenSizes = (long)TokenEntitySizes.TOKEN_ENTITY_SIZES.bytesUsedToRecordTokenTransfers(tokenCreateMeta.getNumTokens(), tokenCreateMeta.getFungibleNumTransfers(), tokenCreateMeta.getNftsTransfers()) * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs();
        accumulator.addRbs(tokenSizes);
        accumulator.addNetworkRbs(tokenCreateMeta.getNetworkRecordRb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
    }

    public void tokenBurnUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenBurnMeta tokenBurnMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenBurnMeta.getBpt());
        accumulator.addNetworkRbs(tokenBurnMeta.getTransferRecordDb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
    }

    public void tokenMintUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenMintMeta tokenMintMeta, UsageAccumulator accumulator, SubType subType) {
        if (SubType.TOKEN_NON_FUNGIBLE_UNIQUE.equals((Object)subType)) {
            accumulator.reset();
            accumulator.addVpt(Math.max(0L, (long)sigUsage.numSigs() - 1L));
        } else {
            accumulator.resetForTransaction(baseMeta, sigUsage);
        }
        accumulator.addBpt(tokenMintMeta.getBpt());
        accumulator.addRbs(tokenMintMeta.getRbs());
        accumulator.addNetworkRbs(tokenMintMeta.getTransferRecordDb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
    }

    public void tokenWipeUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenWipeMeta tokenWipeMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenWipeMeta.getBpt());
        accumulator.addNetworkRbs(tokenWipeMeta.getTransferRecordDb() * SingletonUsageProperties.USAGE_PROPERTIES.legacyReceiptStorageSecs());
    }

    public void tokenFreezeUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenFreezeMeta tokenFreezeMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenFreezeMeta.getBpt());
    }

    public void tokenUnfreezeUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenUnfreezeMeta tokenUnfreezeMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenUnfreezeMeta.getBpt());
    }

    public void tokenPauseUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenPauseMeta tokenPauseMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenPauseMeta.getBpt());
    }

    public void tokenUnpauseUsage(SigUsage sigUsage, BaseTransactionMeta baseMeta, TokenUnpauseMeta tokenUnpauseMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        accumulator.addBpt(tokenUnpauseMeta.getBpt());
    }

    private int plusCollectorSize(int feeReprSize) {
        return feeReprSize + 24;
    }
}

