/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers.formats;

import com.hedera.node.app.records.impl.producers.BlockRecordWriter;
import com.hedera.node.app.records.impl.producers.BlockRecordWriterFactory;
import com.hedera.node.app.records.impl.producers.formats.v6.BlockRecordWriterV6;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockRecordStreamConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.FileSystem;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.base.crypto.Signer;

@Singleton
public class BlockRecordWriterFactoryImpl
implements BlockRecordWriterFactory {
    private final ConfigProvider configProvider;
    private final Signer signer;
    private final NodeInfo selfNodeInfo;
    private final FileSystem fileSystem;

    @Inject
    public BlockRecordWriterFactoryImpl(@NonNull ConfigProvider configProvider, @NonNull NodeInfo selfNodeInfo, @NonNull Signer signer, @NonNull FileSystem fileSystem) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.fileSystem = Objects.requireNonNull(fileSystem);
        this.selfNodeInfo = Objects.requireNonNull(selfNodeInfo);
        this.signer = Objects.requireNonNull(signer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public BlockRecordWriter create() throws RuntimeException {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        BlockRecordStreamConfig recordStreamConfig = (BlockRecordStreamConfig)config.getConfigData(BlockRecordStreamConfig.class);
        int recordFileVersion = recordStreamConfig.recordFileVersion();
        switch (recordFileVersion) {
            case 6: {
                return new BlockRecordWriterV6((BlockRecordStreamConfig)this.configProvider.getConfiguration().getConfigData(BlockRecordStreamConfig.class), this.selfNodeInfo, this.signer, this.fileSystem);
            }
            case 7: {
                throw new IllegalArgumentException("Record file version 7 is not yet supported");
            }
            default: {
                throw new IllegalArgumentException("Unknown record file version: " + recordFileVersion);
            }
        }
    }
}

