/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl;

import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.ScheduledCounts;
import com.hedera.hapi.node.state.schedule.ScheduledOrder;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.schedule.impl.ScheduleStoreUtility;
import com.hedera.node.app.service.schedule.impl.schemas.V0490ScheduleSchema;
import com.hedera.node.app.service.schedule.impl.schemas.V0570ScheduleSchema;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class ReadableScheduleStoreImpl
implements ReadableScheduleStore {
    private static final String NULL_STATE_IN_CONSTRUCTOR_MESSAGE = "Null states instance passed to ReadableScheduleStore constructor, possible state corruption.";
    private final ReadableKVState<ScheduleID, Schedule> schedulesById;
    private final ReadableKVState<TimestampSeconds, ScheduledCounts> scheduledCounts;
    private final ReadableKVState<TimestampSeconds, ThrottleUsageSnapshots> scheduledUsages;
    private final ReadableKVState<ScheduledOrder, ScheduleID> scheduledOrders;
    private final ReadableKVState<ProtoBytes, ScheduleID> scheduleIdByStringHash;
    private final ReadableEntityCounters entityCounters;

    public ReadableScheduleStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states, NULL_STATE_IN_CONSTRUCTOR_MESSAGE);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.schedulesById = states.get(V0490ScheduleSchema.SCHEDULES_BY_ID_STATE_ID);
        this.scheduledCounts = states.get(V0570ScheduleSchema.SCHEDULED_COUNTS_STATE_ID);
        this.scheduledOrders = states.get(V0570ScheduleSchema.SCHEDULED_ORDERS_STATE_ID);
        this.scheduledUsages = states.get(V0570ScheduleSchema.SCHEDULED_USAGES_STATE_ID);
        this.scheduleIdByStringHash = states.get(V0570ScheduleSchema.SCHEDULE_ID_BY_EQUALITY_STATE_ID);
    }

    @Nullable
    public Schedule get(@Nullable ScheduleID id) {
        return id == null ? null : (Schedule)this.schedulesById.get((Object)id);
    }

    @Nullable
    public ScheduleID getByEquality(@NonNull Schedule schedule) {
        Objects.requireNonNull(schedule);
        Bytes bytesHash = ScheduleStoreUtility.calculateBytesHash(schedule);
        return (ScheduleID)this.scheduleIdByStringHash.get((Object)new ProtoBytes(bytesHash));
    }

    @Nullable
    public ScheduleID getByOrder(@NonNull ScheduledOrder scheduledOrder) {
        Objects.requireNonNull(scheduledOrder);
        return (ScheduleID)this.scheduledOrders.get((Object)scheduledOrder);
    }

    public long numSchedulesInState() {
        return this.entityCounters.getCounterFor(EntityType.SCHEDULE);
    }

    public int numTransactionsScheduledAt(long consensusSecond) {
        ScheduledCounts counts = (ScheduledCounts)this.scheduledCounts.get((Object)new TimestampSeconds(consensusSecond));
        return counts == null ? 0 : counts.numberScheduled();
    }

    @Nullable
    public ScheduledCounts scheduledCountsAt(long consensusSecond) {
        return (ScheduledCounts)this.scheduledCounts.get((Object)new TimestampSeconds(consensusSecond));
    }

    @Nullable
    public ThrottleUsageSnapshots usageSnapshotsForScheduled(long consensusSecond) {
        return (ThrottleUsageSnapshots)this.scheduledUsages.get((Object)new TimestampSeconds(consensusSecond));
    }
}

