/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.token.TokenCreateTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenCreateWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenKeyWrapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.inject.Singleton;

@Singleton
public class CreateSyntheticTxnFactory {
    private CreateSyntheticTxnFactory() {
    }

    @NonNull
    public static TokenCreateTransactionBody.Builder createToken(@NonNull TokenCreateWrapper tokenCreateWrapper) {
        TokenCreateTransactionBody.Builder txnBodyBuilder = TokenCreateTransactionBody.newBuilder();
        txnBodyBuilder.name(tokenCreateWrapper.getName()).symbol(tokenCreateWrapper.getSymbol()).decimals(tokenCreateWrapper.getDecimals()).tokenType(tokenCreateWrapper.isFungible() ? TokenType.FUNGIBLE_COMMON : TokenType.NON_FUNGIBLE_UNIQUE).supplyType(tokenCreateWrapper.isSupplyTypeFinite() ? TokenSupplyType.FINITE : TokenSupplyType.INFINITE).maxSupply(tokenCreateWrapper.getMaxSupply()).initialSupply(tokenCreateWrapper.getInitSupply()).freezeDefault(tokenCreateWrapper.isFreezeDefault()).memo(tokenCreateWrapper.getMemo());
        if (tokenCreateWrapper.getTreasury() != null) {
            txnBodyBuilder.treasury(tokenCreateWrapper.getTreasury());
        }
        CreateSyntheticTxnFactory.setTokenKeys(tokenCreateWrapper, txnBodyBuilder);
        CreateSyntheticTxnFactory.setExpiry(tokenCreateWrapper, txnBodyBuilder);
        CreateSyntheticTxnFactory.addCustomFees(tokenCreateWrapper, txnBodyBuilder);
        return txnBodyBuilder;
    }

    public static TokenCreateTransactionBody.Builder createTokenWithMetadata(@NonNull TokenCreateWrapper tokenCreateWrapper) {
        TokenCreateTransactionBody.Builder transactionBodyBuilder = CreateSyntheticTxnFactory.createToken(tokenCreateWrapper);
        CreateSyntheticTxnFactory.setMetadata(tokenCreateWrapper, transactionBodyBuilder);
        CreateSyntheticTxnFactory.setMetadataKey(tokenCreateWrapper, transactionBodyBuilder);
        return transactionBodyBuilder;
    }

    private static void setTokenKeys(@NonNull TokenCreateWrapper tokenCreateWrapper, TokenCreateTransactionBody.Builder txnBodyBuilder) {
        tokenCreateWrapper.getTokenKeys().forEach(tokenKeyWrapper -> {
            Key key = tokenKeyWrapper.key().asGrpc();
            if (Key.DEFAULT.equals((Object)key)) {
                throw new IllegalArgumentException();
            }
            if (tokenKeyWrapper.isUsedForAdminKey()) {
                txnBodyBuilder.adminKey(key);
            }
            if (tokenKeyWrapper.isUsedForKycKey()) {
                txnBodyBuilder.kycKey(key);
            }
            if (tokenKeyWrapper.isUsedForFreezeKey()) {
                txnBodyBuilder.freezeKey(key);
            }
            if (tokenKeyWrapper.isUsedForWipeKey()) {
                txnBodyBuilder.wipeKey(key);
            }
            if (tokenKeyWrapper.isUsedForSupplyKey()) {
                txnBodyBuilder.supplyKey(key);
            }
            if (tokenKeyWrapper.isUsedForFeeScheduleKey()) {
                txnBodyBuilder.feeScheduleKey(key);
            }
            if (tokenKeyWrapper.isUsedForPauseKey()) {
                txnBodyBuilder.pauseKey(key);
            }
        });
    }

    private static void setExpiry(@NonNull TokenCreateWrapper tokenCreateWrapper, @NonNull TokenCreateTransactionBody.Builder txnBodyBuilder) {
        if (tokenCreateWrapper.getExpiry().second() != 0L) {
            txnBodyBuilder.expiry(Timestamp.newBuilder().seconds(tokenCreateWrapper.getExpiry().second()).build());
        }
        if (tokenCreateWrapper.getExpiry().autoRenewAccount() != null) {
            txnBodyBuilder.autoRenewAccount(tokenCreateWrapper.getExpiry().autoRenewAccount());
        }
        if (tokenCreateWrapper.getExpiry().autoRenewPeriod() != null) {
            txnBodyBuilder.autoRenewPeriod(tokenCreateWrapper.getExpiry().autoRenewPeriod());
        }
    }

    private static void setMetadataKey(@NonNull TokenCreateWrapper tokenCreateWrapper, TokenCreateTransactionBody.Builder txnBodyBuilder) {
        tokenCreateWrapper.getTokenKeys().stream().filter(TokenKeyWrapper::isUsedForMetadataKey).map(tokenKeyWrapper -> tokenKeyWrapper.key().asGrpc()).forEach(arg_0 -> ((TokenCreateTransactionBody.Builder)txnBodyBuilder).metadataKey(arg_0));
    }

    private static void setMetadata(@NonNull TokenCreateWrapper tokenCreateWrapper, TokenCreateTransactionBody.Builder txnBodyBuilder) {
        if (tokenCreateWrapper.getMetadata() != null) {
            txnBodyBuilder.metadata(tokenCreateWrapper.getMetadata());
        }
    }

    private static void addCustomFees(@NonNull TokenCreateWrapper tokenCreateWrapper, @NonNull TokenCreateTransactionBody.Builder txnBodyBuilder) {
        Stream<CustomFee> fractionalFees = tokenCreateWrapper.getFractionalFees().stream().map(TokenCreateWrapper.FractionalFeeWrapper::asGrpc);
        Stream<CustomFee> fixedFees = tokenCreateWrapper.getFixedFees().stream().map(TokenCreateWrapper.FixedFeeWrapper::asGrpc);
        Stream<CustomFee> royaltyFees = tokenCreateWrapper.getRoyaltyFees().stream().map(TokenCreateWrapper.RoyaltyFeeWrapper::asGrpc);
        List allFees = Stream.of(fixedFees, fractionalFees, royaltyFees).flatMap(Function.identity()).toList();
        if (!allFees.isEmpty()) {
            txnBodyBuilder.customFees(allFees);
        }
    }
}

