/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.workflows;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.spi.fees.FeeCharging;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public class HandleException
extends RuntimeException {
    private final ResponseCodeEnum status;
    @Nullable
    private final Consumer<FeeCharging.Context> rollbackFeesCb;

    public HandleException(ResponseCodeEnum status) {
        this(status, null);
    }

    public HandleException(@NonNull ResponseCodeEnum status, @Nullable Consumer<FeeCharging.Context> rollbackFeesCb) {
        super(status.protoName());
        this.status = Objects.requireNonNull(status);
        this.rollbackFeesCb = rollbackFeesCb;
    }

    public void maybeReplayFees(@NonNull FeeCharging.Context context) {
        if (this.rollbackFeesCb != null) {
            this.rollbackFeesCb.accept(context);
        }
    }

    @Override
    public Throwable initCause(Throwable cause) {
        throw new UnsupportedOperationException("HandleException must not chain a cause");
    }

    public ResponseCodeEnum getStatus() {
        return this.status;
    }

    public static void validateTrue(boolean flag, ResponseCodeEnum errorStatus) {
        if (!flag) {
            throw new HandleException(errorStatus);
        }
    }

    public static void validateFalse(boolean flag, ResponseCodeEnum errorStatus) {
        HandleException.validateTrue(!flag, errorStatus);
    }

    @Override
    public String toString() {
        return "HandleException{status=" + String.valueOf(this.status) + "}";
    }
}

