/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.metrics;

import com.hedera.node.app.spi.info.NodeInfo;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.DoubleGauge;
import com.swirlds.metrics.api.LongGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.block.api.PublishStreamResponse;

@Singleton
public class BlockStreamMetrics {
    private static final Logger logger = LogManager.getLogger(BlockStreamMetrics.class);
    private static final String APP_CATEGORY = "app";
    private final Metrics metrics;
    private final NodeInfo selfNodeInfo;
    private final Map<PublishStreamResponse.EndOfStream.Code, Counter> endOfStreamCounters = new EnumMap<PublishStreamResponse.EndOfStream.Code, Counter>(PublishStreamResponse.EndOfStream.Code.class);
    private Counter skipBlockCounter;
    private Counter resendBlockCounter;
    private Counter acknowledgedBlockCounter;
    private Counter blockNodeConnectionErrorCounter;
    private Counter unknownRespCounter;
    private LongGauge producingBlockNumberGauge;
    private LongGauge oldestUnacknowledgedBlockTimeGauge;
    private LongGauge latestAcknowledgedBlockNumberGauge;
    private DoubleGauge blockBufferSaturationGauge;

    @Inject
    public BlockStreamMetrics(@NonNull Metrics metrics, @NonNull NodeInfo selfNodeInfo) {
        this.metrics = Objects.requireNonNull(metrics);
        this.selfNodeInfo = Objects.requireNonNull(selfNodeInfo);
    }

    public void registerMetrics() {
        long localNodeId = this.selfNodeInfo.nodeId();
        String nodeLabel = "_node" + localNodeId;
        logger.info("Registering BlockStreamMetrics for node {}", (Object)localNodeId);
        for (PublishStreamResponse.EndOfStream.Code code : PublishStreamResponse.EndOfStream.Code.values()) {
            if (code == PublishStreamResponse.EndOfStream.Code.UNKNOWN) continue;
            String metricName = "endOfStream_" + code.name() + nodeLabel;
            Counter counter = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(APP_CATEGORY, metricName).withDescription("Total number of EndOfStream responses with code " + code.name() + " received by node " + localNodeId));
            this.endOfStreamCounters.put(code, counter);
        }
        String skipMetricName = "skipBlock" + nodeLabel;
        this.skipBlockCounter = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(APP_CATEGORY, skipMetricName).withDescription("Total number of SkipBlock responses received by node " + localNodeId));
        String resendMetricName = "resendBlock" + nodeLabel;
        this.resendBlockCounter = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(APP_CATEGORY, resendMetricName).withDescription("Total number of ResendBlock responses received by node " + localNodeId));
        String ackMetricName = "acknowledgeBlock" + nodeLabel;
        this.acknowledgedBlockCounter = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(APP_CATEGORY, ackMetricName).withDescription("Total number of block acknowledgements received by node " + localNodeId));
        String blockNodeConnectionErrorMetricName = "blockNodeConnectionErrorCount" + nodeLabel;
        this.blockNodeConnectionErrorCounter = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(APP_CATEGORY, blockNodeConnectionErrorMetricName).withDescription("Total number of block node connection errors for node " + localNodeId));
        String producingBlockNumMetricName = "producingBlockNumber" + nodeLabel;
        this.producingBlockNumberGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)new LongGauge.Config(APP_CATEGORY, producingBlockNumMetricName).withDescription("Current block number being produced by node " + localNodeId));
        String oldestUnackTimeMetricName = "timeOfOldestUnacknowledgedBlock" + nodeLabel;
        this.oldestUnacknowledgedBlockTimeGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)new LongGauge.Config(APP_CATEGORY, oldestUnackTimeMetricName).withDescription("Timestamp of the oldest unacknowledged block for node " + localNodeId));
        String latestAckBlockNumMetricName = "latestAcknowledgedBlockNumber" + nodeLabel;
        this.latestAcknowledgedBlockNumberGauge = (LongGauge)this.metrics.getOrCreate((MetricConfig)new LongGauge.Config(APP_CATEGORY, latestAckBlockNumMetricName).withDescription("Latest block number acknowledged for node " + localNodeId));
        String unknownRespMetricName = "unknownBlockNodeResponse" + nodeLabel;
        this.unknownRespCounter = (Counter)this.metrics.getOrCreate((MetricConfig)new Counter.Config(APP_CATEGORY, unknownRespMetricName).withDescription("Total number of unexpected responses received from block nodes"));
        String bufferSaturationMetricName = "blockBufferSaturation" + nodeLabel;
        this.blockBufferSaturationGauge = (DoubleGauge)this.metrics.getOrCreate((MetricConfig)new DoubleGauge.Config(APP_CATEGORY, bufferSaturationMetricName).withDescription("Block buffer saturation; Values closer to 100 mean the buffer is nearingsaturation and backpressure may be applied, and values at or above 100 mean the buffer is fully saturated and potentially overflowing"));
        logger.info("Finished registering BlockStreamMetrics for node {}", (Object)localNodeId);
    }

    public void incrementEndOfStreamCount(@NonNull PublishStreamResponse.EndOfStream.Code code) {
        if (code != PublishStreamResponse.EndOfStream.Code.UNKNOWN) {
            Counter counter = this.endOfStreamCounters.get(code);
            if (counter != null) {
                counter.increment();
            } else {
                logger.warn("EndOfStream counter for code {} not found.", (Object)code);
            }
        }
    }

    public void incrementSkipBlockCount() {
        if (this.skipBlockCounter != null) {
            this.skipBlockCounter.increment();
        } else {
            logger.warn("SkipBlock counter not found.");
        }
    }

    public void incrementResendBlockCount() {
        if (this.resendBlockCounter != null) {
            this.resendBlockCounter.increment();
        } else {
            logger.warn("ResendBlock counter not found.");
        }
    }

    public void incrementAcknowledgedBlockCount() {
        if (this.acknowledgedBlockCounter != null) {
            this.acknowledgedBlockCounter.increment();
        } else {
            logger.warn("acknowledgedBlockCounter not found.");
        }
    }

    public void incrementUnknownResponseCount() {
        if (this.unknownRespCounter != null) {
            this.unknownRespCounter.increment();
        } else {
            logger.warn("unknownRespCounter not found");
        }
    }

    public void setProducingBlockNumber(long blockNumber) {
        if (this.producingBlockNumberGauge != null) {
            this.producingBlockNumberGauge.set(blockNumber);
        } else {
            logger.warn("producingBlockNumberGauge not found.");
        }
    }

    public void setOldestUnacknowledgedBlockTime(long timestamp) {
        if (this.oldestUnacknowledgedBlockTimeGauge != null) {
            this.oldestUnacknowledgedBlockTimeGauge.set(timestamp);
        } else {
            logger.warn("oldestUnacknowledgedBlockTimeGauge not found.");
        }
    }

    public void setLatestAcknowledgedBlockNumber(long blockNumber) {
        if (this.latestAcknowledgedBlockNumberGauge != null) {
            this.latestAcknowledgedBlockNumberGauge.set(blockNumber);
        } else {
            logger.warn("latestAcknowledgedBlockNumberGauge not found.");
        }
    }

    public void incrementOnErrorCount() {
        if (this.blockNodeConnectionErrorCounter != null) {
            this.blockNodeConnectionErrorCounter.increment();
        } else {
            logger.warn("onErrorCounter not found.");
        }
    }

    public void updateBlockBufferSaturation(double saturation) {
        if (this.blockBufferSaturationGauge != null) {
            this.blockBufferSaturationGauge.set(saturation);
        }
    }
}

