/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.node.app.records.impl.BlockRecordStreamProducer;
import com.hedera.node.app.records.impl.producers.BlockRecordFormat;
import com.hedera.node.app.records.impl.producers.BlockRecordWriter;
import com.hedera.node.app.records.impl.producers.BlockRecordWriterFactory;
import com.hedera.node.app.records.impl.producers.SerializedSingleTransactionRecord;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class StreamFileProducerSingleThreaded
implements BlockRecordStreamProducer {
    private static final Logger logger = LogManager.getLogger(StreamFileProducerSingleThreaded.class);
    private final BlockRecordWriterFactory writerFactory;
    private final SemanticVersion hapiVersion;
    private final BlockRecordFormat format;
    private BlockRecordWriter writer;
    private Bytes runningHash = null;
    private Bytes runningHashNMinus1 = null;
    private Bytes runningHashNMinus2 = null;
    private Bytes runningHashNMinus3 = null;
    private long currentBlockNumber = 0L;

    @Inject
    public StreamFileProducerSingleThreaded(@NonNull BlockRecordFormat format, @NonNull BlockRecordWriterFactory writerFactory, SemanticVersion hapiVersion) {
        this.writerFactory = Objects.requireNonNull(writerFactory);
        this.format = Objects.requireNonNull(format);
        this.hapiVersion = hapiVersion;
    }

    @Override
    public void switchBlocks(long lastBlockNumber, long newBlockNumber, @NonNull Instant newBlockFirstTransactionConsensusTime) {
        if (newBlockNumber != lastBlockNumber + 1L) {
            throw new IllegalArgumentException("Block numbers must be sequential, newBlockNumber=" + newBlockNumber + ", lastBlockNumber=" + lastBlockNumber);
        }
        Objects.requireNonNull(newBlockFirstTransactionConsensusTime);
        this.currentBlockNumber = newBlockNumber;
        HashObject lastRunningHash = this.asHashObject(this.getRunningHash());
        this.closeWriter(lastRunningHash, lastBlockNumber);
        this.openWriter(newBlockNumber, lastRunningHash, newBlockFirstTransactionConsensusTime);
        logger.debug("Initializing block record writer for block {} with running hash {}", (Object)this.currentBlockNumber, (Object)lastRunningHash);
    }

    @Override
    public void close() {
        this.closeWriter(this.asHashObject(this.getRunningHash()), this.currentBlockNumber);
        this.runningHash = null;
        this.runningHashNMinus1 = null;
        this.runningHashNMinus2 = null;
        this.runningHashNMinus3 = null;
    }

    @Override
    public void initRunningHash(@NonNull RunningHashes runningHashes) {
        if (this.runningHash != null) {
            throw new IllegalStateException("initRunningHash() must only be called once");
        }
        if (runningHashes.runningHash().equals((Object)Bytes.EMPTY)) {
            throw new IllegalArgumentException("The initial running hash cannot be empty");
        }
        this.runningHash = runningHashes.runningHash();
        this.runningHashNMinus1 = runningHashes.nMinus1RunningHash();
        this.runningHashNMinus2 = runningHashes.nMinus2RunningHash();
        this.runningHashNMinus3 = runningHashes.nMinus3RunningHash();
    }

    @Override
    @NonNull
    public Bytes getRunningHash() {
        assert (this.runningHash != null) : "initRunningHash() must be called before getRunningHash()";
        return this.runningHash;
    }

    @Override
    @Nullable
    public Bytes getNMinus3RunningHash() {
        return this.runningHashNMinus3;
    }

    @Override
    public void writeRecordStreamItems(@NonNull Stream<SingleTransactionRecord> recordStreamItems) {
        List<SerializedSingleTransactionRecord> serializedItems = recordStreamItems.map(item -> this.format.serialize((SingleTransactionRecord)item, this.currentBlockNumber, this.hapiVersion)).toList();
        this.runningHashNMinus3 = this.runningHashNMinus2;
        this.runningHashNMinus2 = this.runningHashNMinus1;
        this.runningHashNMinus1 = this.runningHash;
        this.runningHash = this.format.computeNewRunningHash(this.runningHash, serializedItems);
        serializedItems.forEach(item -> {
            try {
                this.writer.writeItem((SerializedSingleTransactionRecord)item);
            }
            catch (Exception e) {
                logger.error("Error writing record stream item to block record writer for block {}", (Object)this.currentBlockNumber, (Object)e);
            }
        });
    }

    private HashObject asHashObject(@NonNull Bytes hash) {
        return new HashObject(HashAlgorithm.SHA_384, (int)hash.length(), hash);
    }

    private void closeWriter(@NonNull HashObject lastRunningHash, long lastBlockNumber) {
        if (this.writer != null) {
            logger.debug("Closing block record writer for block {} with running hash {}", (Object)lastBlockNumber, (Object)lastRunningHash);
            try {
                this.writer.close(lastRunningHash);
            }
            catch (Exception e) {
                logger.error("Error closing block record writer for block {}", (Object)lastBlockNumber, (Object)e);
            }
        }
    }

    private void openWriter(long newBlockNumber, @NonNull HashObject lastRunningHash, @NonNull Instant newBlockFirstTransactionConsensusTime) {
        try {
            this.writer = this.writerFactory.create();
            this.writer.init(this.hapiVersion, lastRunningHash, newBlockFirstTransactionConsensusTime, this.currentBlockNumber);
        }
        catch (Exception e) {
            logger.error("Error creating or initializing a block record writer for block {}", (Object)newBlockNumber, (Object)e);
            throw e;
        }
    }
}

