/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.file.impl.handlers;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.FileGetInfoQuery;
import com.hedera.hapi.node.file.FileGetInfoResponse;
import com.hedera.hapi.node.state.file.File;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.file.ExtantFileContext;
import com.hedera.node.app.hapi.fees.usage.file.FileOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.file.FileMetadata;
import com.hedera.node.app.service.file.ReadableFileStore;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.file.impl.base.FileQueryBase;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Query;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.utility.CommonUtils;

@Singleton
public class FileGetInfoHandler
extends FileQueryBase {
    private final FileOpsUsage fileOpsUsage;
    private final Cryptography cryptography;

    @Inject
    public FileGetInfoHandler(FileOpsUsage fileOpsUsage) {
        this.fileOpsUsage = fileOpsUsage;
        this.cryptography = CryptographyProvider.getInstance();
    }

    @NonNull
    public QueryHeader extractHeader(@NonNull com.hedera.hapi.node.transaction.Query query) {
        Objects.requireNonNull(query);
        return query.fileGetInfoOrThrow().header();
    }

    @NonNull
    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        FileGetInfoResponse.Builder response = FileGetInfoResponse.newBuilder().header(header);
        return Response.newBuilder().fileGetInfo(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        com.hedera.hapi.node.transaction.Query query = context.query();
        FileGetInfoQuery op = query.fileGetInfoOrThrow();
        if (!op.hasFileID()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_FILE_ID);
        }
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        com.hedera.hapi.node.transaction.Query query = queryContext.query();
        ReadableFileStore fileStore = (ReadableFileStore)queryContext.createStore(ReadableFileStore.class);
        FileGetInfoQuery op = query.fileGetInfoOrThrow();
        FileID fileId = op.fileIDOrElse(FileID.DEFAULT);
        File file = fileStore.getFileLeaf(fileId);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.Query)query), file));
    }

    @NonNull
    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        com.hedera.hapi.node.transaction.Query query = context.query();
        ReadableFileStore fileStore = (ReadableFileStore)context.createStore(ReadableFileStore.class);
        ReadableUpgradeFileStore upgradeFileStore = (ReadableUpgradeFileStore)context.createStore(ReadableUpgradeFileStore.class);
        LedgerConfig ledgerConfig = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        FilesConfig fileServiceConfig = (FilesConfig)context.configuration().getConfigData(FilesConfig.class);
        FileGetInfoQuery op = query.fileGetInfoOrThrow();
        FileGetInfoResponse.Builder responseBuilder = FileGetInfoResponse.newBuilder();
        FileID file = op.fileIDOrThrow();
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        responseBuilder.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            Optional<FileGetInfoResponse.FileInfo> optionalInfo;
            try {
                optionalInfo = this.infoForFile(file, fileStore, ledgerConfig, upgradeFileStore, fileServiceConfig);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to read file contents", e);
            }
            if (optionalInfo.isEmpty()) {
                responseBuilder.header(header.copyBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.INVALID_FILE_ID).build());
            } else {
                responseBuilder.fileInfo(optionalInfo.get());
            }
        }
        return Response.newBuilder().fileGetInfo(responseBuilder).build();
    }

    private Optional<FileGetInfoResponse.FileInfo> infoForFile(@NonNull FileID fileID, @NonNull ReadableFileStore fileStore, @NonNull LedgerConfig ledgerConfig, @NonNull ReadableUpgradeFileStore upgradeFileStore, @NonNull FilesConfig fileServiceConfig) throws IOException {
        FileMetadata meta = null;
        long contentSize = 0L;
        if (fileID.fileNum() >= fileServiceConfig.softwareUpdateRange().left() && fileID.fileNum() <= fileServiceConfig.softwareUpdateRange().right()) {
            File file = upgradeFileStore.peek(fileID);
            if (file != null) {
                byte[] contents = upgradeFileStore.getFull(fileID).toByteArray();
                contentSize = contents.length;
                String upgradeHash = CommonUtils.hex((byte[])this.cryptography.digestBytesSync(contents));
                meta = new FileMetadata(file.fileId(), Timestamp.newBuilder().seconds(file.expirationSecond()).build(), file.keys(), Bytes.EMPTY, upgradeHash, file.deleted(), Timestamp.newBuilder().seconds(file.preSystemDeleteExpirationSecond()).build());
            }
        } else {
            meta = fileStore.getFileMetadata(fileID);
        }
        if (meta == null) {
            return Optional.empty();
        }
        FileGetInfoResponse.FileInfo.Builder info = FileGetInfoResponse.FileInfo.newBuilder();
        info.memo(meta.memo() == null ? "" : meta.memo());
        info.fileID(fileID);
        info.size(contentSize > 0L ? contentSize : meta.contents().length());
        info.expirationTime(meta.expirationTimestamp());
        info.deleted(meta.deleted());
        info.keys(meta.keys());
        info.ledgerId(ledgerConfig.id());
        return Optional.of(info.build());
    }

    private FeeData usageGiven(@NonNull Query query, @Nullable File file) {
        Objects.requireNonNull(query);
        if (file == null) {
            return FeeData.getDefaultInstance();
        }
        com.hederahashgraph.api.proto.java.File details = CommonPbjConverters.fromPbj((File)file);
        ExtantFileContext ctx = ExtantFileContext.newBuilder().setCurrentSize((long)details.getContents().toByteArray().length).setCurrentWacl(details.getKeys()).setCurrentMemo(details.getMemo()).setCurrentExpiry(details.getExpirationSecond()).build();
        return this.fileOpsUsage.fileInfoUsage(query, ctx);
    }
}

