/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.config.extensions.sources;

import com.swirlds.base.ArgumentUtils;
import com.swirlds.config.api.source.ConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public final class SystemEnvironmentConfigSource
implements ConfigSource {
    private static SystemEnvironmentConfigSource instance;

    private SystemEnvironmentConfigSource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SystemEnvironmentConfigSource getInstance() {
        if (instance != null) return instance;
        Class<SystemEnvironmentConfigSource> clazz = SystemEnvironmentConfigSource.class;
        synchronized (SystemEnvironmentConfigSource.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            instance = new SystemEnvironmentConfigSource();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @NonNull
    public Set<String> getPropertyNames() {
        return System.getenv().keySet();
    }

    public String getValue(@NonNull String propertyName) {
        ArgumentUtils.throwArgBlank((String)propertyName, (String)"propertyName");
        if (!this.getPropertyNames().contains(propertyName)) {
            throw new NoSuchElementException("Property " + propertyName + " is not defined");
        }
        return System.getenv(propertyName);
    }

    public boolean isListProperty(@NonNull String propertyName) throws NoSuchElementException {
        return false;
    }

    @NonNull
    public List<String> getListValue(@NonNull String propertyName) throws NoSuchElementException {
        return List.of();
    }

    public int getOrdinal() {
        return 300;
    }
}

