/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.GrpcCall;
import com.hedera.pbj.runtime.grpc.GrpcClient;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

public interface CryptoServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "CryptoService";
    public static final String FULL_NAME = "proto.CryptoService";

    @NonNull
    public TransactionResponse createAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse updateAccount(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse cryptoTransfer(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse cryptoDelete(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse approveAllowances(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse deleteAllowances(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse addLiveHash(@NonNull Transaction var1);

    @NonNull
    public TransactionResponse deleteLiveHash(@NonNull Transaction var1);

    @NonNull
    public Response getLiveHash(@NonNull Query var1);

    @NonNull
    public Response getAccountRecords(@NonNull Query var1);

    @NonNull
    public Response cryptoGetBalance(@NonNull Query var1);

    @NonNull
    public Response getAccountInfo(@NonNull Query var1);

    @NonNull
    public Response getTransactionReceipts(@NonNull Query var1);

    @NonNull
    public Response getTxRecordByTxID(@NonNull Query var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(CryptoServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        CryptoServiceMethod m = (CryptoServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::createAccount).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::updateAccount).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::cryptoTransfer).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::cryptoDelete).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::approveAllowances).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 5 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::deleteAllowances).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 6 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::addLiveHash).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 7 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseTransaction(bytes, options)).method(this::deleteLiveHash).mapResponse(reply -> CryptoServiceInterface.serializeTransactionResponse(reply, options)).respondTo(replies).build();
                case 8 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseQuery(bytes, options)).method(this::getLiveHash).mapResponse(reply -> CryptoServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 9 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseQuery(bytes, options)).method(this::getAccountRecords).mapResponse(reply -> CryptoServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 10 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseQuery(bytes, options)).method(this::cryptoGetBalance).mapResponse(reply -> CryptoServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 11 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseQuery(bytes, options)).method(this::getAccountInfo).mapResponse(reply -> CryptoServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 12 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseQuery(bytes, options)).method(this::getTransactionReceipts).mapResponse(reply -> CryptoServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
                case 13 -> Pipelines.unary().mapRequest(bytes -> CryptoServiceInterface.parseQuery(bytes, options)).method(this::getTxRecordByTxID).mapResponse(reply -> CryptoServiceInterface.serializeResponse(reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private static Codec<Transaction> getTransactionCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Transaction.JSON;
        }
        return Transaction.PROTOBUF;
    }

    @NonNull
    private static Codec<TransactionResponse> getTransactionResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return TransactionResponse.JSON;
        }
        return TransactionResponse.PROTOBUF;
    }

    @NonNull
    private static Codec<Query> getQueryCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Query.JSON;
        }
        return Query.PROTOBUF;
    }

    @NonNull
    private static Codec<Response> getResponseCodec(@NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Response.JSON;
        }
        return Response.PROTOBUF;
    }

    @NonNull
    private static Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Transaction)CryptoServiceInterface.getTransactionCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        return (Query)CryptoServiceInterface.getQueryCodec(options).parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private static Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return CryptoServiceInterface.getTransactionResponseCodec(options).toBytes((Object)reply);
    }

    @NonNull
    private static Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        return CryptoServiceInterface.getResponseCodec(options).toBytes((Object)reply);
    }

    public static enum CryptoServiceMethod implements ServiceInterface.Method
    {
        createAccount,
        updateAccount,
        cryptoTransfer,
        cryptoDelete,
        approveAllowances,
        deleteAllowances,
        addLiveHash,
        deleteLiveHash,
        getLiveHash,
        getAccountRecords,
        cryptoGetBalance,
        getAccountInfo,
        getTransactionReceipts,
        getTxRecordByTxID;

    }

    public static class CryptoServiceClient
    implements CryptoServiceInterface {
        private final GrpcClient grpcClient;
        private final ServiceInterface.RequestOptions requestOptions;

        public CryptoServiceClient(@NonNull GrpcClient grpcClient, @NonNull ServiceInterface.RequestOptions requestOptions) {
            this.grpcClient = Objects.requireNonNull(grpcClient);
            this.requestOptions = Objects.requireNonNull(requestOptions);
        }

        @Override
        @NonNull
        public TransactionResponse createAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("createAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/createAccount", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to createAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse updateAccount(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("updateAccount is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/updateAccount", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to updateAccount completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse cryptoTransfer(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("cryptoTransfer is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/cryptoTransfer", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to cryptoTransfer completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse cryptoDelete(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("cryptoDelete is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/cryptoDelete", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to cryptoDelete completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse approveAllowances(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("approveAllowances is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/approveAllowances", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to approveAllowances completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse deleteAllowances(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("deleteAllowances is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/deleteAllowances", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to deleteAllowances completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse addLiveHash(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("addLiveHash is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/addLiveHash", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to addLiveHash completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public TransactionResponse deleteLiveHash(@NonNull Transaction request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<TransactionResponse> pipeline = new Pipeline<TransactionResponse>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(TransactionResponse reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("deleteLiveHash is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/deleteLiveHash", CryptoServiceInterface.getTransactionCodec(this.requestOptions), CryptoServiceInterface.getTransactionResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (TransactionResponse)replyRef.get();
            }
            throw new RuntimeException("Call to deleteLiveHash completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getLiveHash(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getLiveHash is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/getLiveHash", CryptoServiceInterface.getQueryCodec(this.requestOptions), CryptoServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getLiveHash completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getAccountRecords(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getAccountRecords is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/getAccountRecords", CryptoServiceInterface.getQueryCodec(this.requestOptions), CryptoServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getAccountRecords completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response cryptoGetBalance(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("cryptoGetBalance is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/cryptoGetBalance", CryptoServiceInterface.getQueryCodec(this.requestOptions), CryptoServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to cryptoGetBalance completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getAccountInfo(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getAccountInfo is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/getAccountInfo", CryptoServiceInterface.getQueryCodec(this.requestOptions), CryptoServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getAccountInfo completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getTransactionReceipts(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getTransactionReceipts is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/getTransactionReceipts", CryptoServiceInterface.getQueryCodec(this.requestOptions), CryptoServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getTransactionReceipts completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }

        @Override
        @NonNull
        public Response getTxRecordByTxID(@NonNull Query request) {
            final AtomicReference replyRef = new AtomicReference();
            final AtomicReference errorRef = new AtomicReference();
            final CountDownLatch latch = new CountDownLatch(1);
            Pipeline<Response> pipeline = new Pipeline<Response>(this){

                public void onSubscribe(Flow.Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Response reply) {
                    if (replyRef.get() != null) {
                        throw new IllegalStateException("getTxRecordByTxID is unary, but received more than one reply. The latest reply is: " + String.valueOf(reply));
                    }
                    replyRef.set(reply);
                    latch.countDown();
                }

                public void onError(Throwable throwable) {
                    errorRef.set(throwable);
                    latch.countDown();
                }

                public void onComplete() {
                    latch.countDown();
                }
            };
            GrpcCall call = this.grpcClient.createCall("proto.CryptoService/getTxRecordByTxID", CryptoServiceInterface.getQueryCodec(this.requestOptions), CryptoServiceInterface.getResponseCodec(this.requestOptions), (Pipeline)pipeline);
            call.sendRequest((Object)request, true);
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (errorRef.get() != null) {
                throw new RuntimeException((Throwable)errorRef.get());
            }
            if (replyRef.get() != null) {
                return (Response)replyRef.get();
            }
            throw new RuntimeException("Call to getTxRecordByTxID completed w/o receiving a reply or an error explicitly. The request was: " + String.valueOf(request));
        }
    }
}

