/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SignatureType;
import com.hedera.hapi.streams.codec.SignatureObjectJsonCodec;
import com.hedera.hapi.streams.codec.SignatureObjectProtoCodec;
import com.hedera.hapi.streams.schema.SignatureObjectSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class SignatureObject {
    public static final Codec<SignatureObject> PROTOBUF = new SignatureObjectProtoCodec();
    public static final JsonCodec<SignatureObject> JSON = new SignatureObjectJsonCodec();
    public static final SignatureObject DEFAULT = SignatureObject.newBuilder().build();
    private final SignatureType type;
    private final int length;
    private final int checksum;
    @NonNull
    private final Bytes signature;
    @Nullable
    private final HashObject hashObject;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public SignatureObject(SignatureType type, int length, int checksum, Bytes signature, HashObject hashObject) {
        this.$unknownFields = null;
        this.type = type;
        this.length = length;
        this.checksum = checksum;
        this.signature = signature != null ? signature : Bytes.EMPTY;
        this.hashObject = hashObject;
    }

    public SignatureObject(SignatureType type, int length, int checksum, Bytes signature, HashObject hashObject, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.type = type;
        this.length = length;
        this.checksum = checksum;
        this.signature = signature != null ? signature : Bytes.EMPTY;
        this.hashObject = hashObject;
    }

    public SignatureType type() {
        return this.type;
    }

    public int length() {
        return this.length;
    }

    public int checksum() {
        return this.checksum;
    }

    public Bytes signature() {
        return this.signature;
    }

    public HashObject hashObject() {
        return this.hashObject;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)SignatureObjectSchema.TYPE, (EnumWithProtoMetadata)this.type);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SignatureObjectSchema.LENGTH, (int)this.length, (boolean)true);
            _size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SignatureObjectSchema.CHECKSUM, (int)this.checksum, (boolean)true);
            _size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignatureObjectSchema.SIGNATURE, (RandomAccessData)this.signature, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignatureObjectSchema.HASH_OBJECT, (Object)this.hashObject, HashObject.PROTOBUF);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.type != null && !this.type.equals((Object)SignatureObject.DEFAULT.type)) {
                result = 31 * result + Integer.hashCode(this.type.protoOrdinal());
            }
            if (this.length != SignatureObject.DEFAULT.length) {
                result = 31 * result + Integer.hashCode(this.length);
            }
            if (this.checksum != SignatureObject.DEFAULT.checksum) {
                result = 31 * result + Integer.hashCode(this.checksum);
            }
            if (this.signature != null && !this.signature.equals((Object)SignatureObject.DEFAULT.signature)) {
                result = 31 * result + this.signature.hashCode();
            }
            if (this.hashObject != null && !this.hashObject.equals(SignatureObject.DEFAULT.hashObject)) {
                result = 31 * result + this.hashObject.hashCode();
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        SignatureObject thatObj = (SignatureObject)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.type == null && thatObj.type != null) {
            return false;
        }
        if (this.type != null && !this.type.equals((Object)thatObj.type)) {
            return false;
        }
        if (this.length != thatObj.length) {
            return false;
        }
        if (this.checksum != thatObj.checksum) {
            return false;
        }
        if (this.signature == null && thatObj.signature != null) {
            return false;
        }
        if (this.signature != null && !this.signature.equals((Object)thatObj.signature)) {
            return false;
        }
        if (this.hashObject == null && thatObj.hashObject != null) {
            return false;
        }
        if (this.hashObject != null && !this.hashObject.equals(thatObj.hashObject)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "SignatureObject[type=" + String.valueOf((Object)this.type) + ", length=" + this.length + ", checksum=" + this.checksum + ", signature=" + String.valueOf(this.signature) + ", hashObject=" + String.valueOf(this.hashObject) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasHashObject() {
        return this.hashObject != null;
    }

    public HashObject hashObjectOrElse(@NonNull HashObject defaultValue) {
        return this.hasHashObject() ? this.hashObject : defaultValue;
    }

    @NonNull
    public HashObject hashObjectOrThrow() {
        return Objects.requireNonNull(this.hashObject, "Field hashObject is null");
    }

    public void ifHashObject(@NonNull Consumer<HashObject> ifPresent) {
        if (this.hasHashObject()) {
            ifPresent.accept(this.hashObject);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.type, this.length, this.checksum, this.signature, this.hashObject, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SignatureType type = SignatureType.fromProtobufOrdinal(0);
        private int length = 0;
        private int checksum = 0;
        @NonNull
        private Bytes signature = Bytes.EMPTY;
        @Nullable
        private HashObject hashObject = null;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(SignatureType type, int length, int checksum, Bytes signature, HashObject hashObject) {
            this.$unknownFields = null;
            this.type = type;
            this.length = length;
            this.checksum = checksum;
            this.signature = signature != null ? signature : Bytes.EMPTY;
            this.hashObject = hashObject;
        }

        public Builder(SignatureType type, int length, int checksum, Bytes signature, HashObject hashObject, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.type = type;
            this.length = length;
            this.checksum = checksum;
            this.signature = signature != null ? signature : Bytes.EMPTY;
            this.hashObject = hashObject;
        }

        public SignatureObject build() {
            return new SignatureObject(this.type, this.length, this.checksum, this.signature, this.hashObject);
        }

        public Builder type(SignatureType type) {
            this.type = type;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder checksum(int checksum) {
            this.checksum = checksum;
            return this;
        }

        public Builder signature(@NonNull Bytes signature) {
            this.signature = signature != null ? signature : Bytes.EMPTY;
            return this;
        }

        public Builder hashObject(@Nullable HashObject hashObject) {
            this.hashObject = hashObject;
            return this;
        }

        public Builder hashObject(HashObject.Builder builder) {
            this.hashObject = builder.build();
            return this;
        }
    }
}

