/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.consensus;

import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.consensus.SubmitMessageMeta;
import com.hedera.node.app.hapi.fees.usage.state.UsageAccumulator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public final class ConsensusOpsUsage {
    private static final long LONG_BASIC_ENTITY_ID_SIZE = 24L;

    @Inject
    public ConsensusOpsUsage() {
    }

    public void submitMessageUsage(SigUsage sigUsage, SubmitMessageMeta submitMeta, BaseTransactionMeta baseMeta, UsageAccumulator accumulator) {
        accumulator.resetForTransaction(baseMeta, sigUsage);
        if (submitMeta.numCustomFees() > 0L) {
            accumulator.addVpt(Math.max(0, sigUsage.numSigs() - 1));
            accumulator.addBpt((24L + (long)submitMeta.numMsgBytes() + 475L) / 500L);
        } else {
            accumulator.addBpt(24L + (long)submitMeta.numMsgBytes());
            int extraReceiptBytes = 56;
            accumulator.addNetworkRbs(10080L);
        }
    }
}

