/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.util.impl.handlers;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.util.UtilPrngTransactionBody;
import com.hedera.node.app.service.util.impl.records.PrngStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class UtilPrngHandler
implements TransactionHandler {
    private static final Logger log = LogManager.getLogger(UtilPrngHandler.class);
    private static final Bytes MISSING_N_MINUS_3_RUNNING_HASH = Bytes.wrap((byte[])new byte[48]);

    @Inject
    public UtilPrngHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        if (context.body().utilPrngOrThrow().range() < 0) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_PRNG_RANGE);
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        int range = feeContext.body().utilPrngOrThrow().range();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction(range > 0 ? 4L : 0L).calculate();
    }

    public void handle(@NonNull HandleContext context) {
        UtilPrngTransactionBody op = context.body().utilPrngOrThrow();
        int range = op.range();
        Bytes pseudoRandomBytes = context.blockRecordInfo().prngSeed();
        if (pseudoRandomBytes == null || pseudoRandomBytes.length() == 0L) {
            log.info("No n-3 record running hash available. Will use all zeros.");
            pseudoRandomBytes = MISSING_N_MINUS_3_RUNNING_HASH;
        }
        PrngStreamBuilder recordBuilder = (PrngStreamBuilder)context.savepointStack().getBaseBuilder(PrngStreamBuilder.class);
        if (range > 0) {
            int pseudoRandomNumber = this.randomNumFromBytes(pseudoRandomBytes, range);
            recordBuilder.entropyNumber(pseudoRandomNumber);
        } else {
            recordBuilder.entropyBytes(pseudoRandomBytes);
        }
    }

    private int randomNumFromBytes(@NonNull Bytes pseudoRandomBytes, int range) {
        int initialBitsValue = ByteBuffer.wrap(pseudoRandomBytes.toByteArray(), 0, 4).getInt();
        return (int)UtilPrngHandler.mod(initialBitsValue, range);
    }

    public static long mod(long dividend, int divisor) {
        if (divisor <= 0) {
            throw new ArithmeticException("Modulus must be positive");
        }
        long result = dividend % (long)divisor;
        return result >= 0L ? result : result + (long)divisor;
    }
}

