/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.apache.tuweni.units.bigints.UInt256;

public class SECPSignature {
    public static final int BYTES_REQUIRED = 65;
    private final byte recId;
    private final BigInteger r;
    private final BigInteger s;
    private final Supplier<Bytes> encoded = Suppliers.memoize(this::_encodedBytes);

    SECPSignature(BigInteger r, BigInteger s, byte recId) {
        this.r = r;
        this.s = s;
        this.recId = recId;
    }

    public static SECPSignature create(BigInteger r, BigInteger s, byte recId, BigInteger curveOrder) {
        Preconditions.checkNotNull((Object)r);
        Preconditions.checkNotNull((Object)s);
        SECPSignature.checkInBounds("r", r, curveOrder);
        SECPSignature.checkInBounds("s", s, curveOrder);
        if (recId != 0 && recId != 1) {
            throw new IllegalArgumentException("Invalid 'recId' value, should be 0 or 1 but got " + recId);
        }
        return new SECPSignature(r, s, recId);
    }

    private static void checkInBounds(String name, BigInteger i, BigInteger curveOrder) {
        if (i.compareTo(BigInteger.ONE) < 0) {
            throw new IllegalArgumentException(String.format("Invalid '%s' value, should be >= 1 but got %s", name, i));
        }
        if (i.compareTo(curveOrder) >= 0) {
            throw new IllegalArgumentException(String.format("Invalid '%s' value, should be < %s but got %s", curveOrder, name, i));
        }
    }

    public static SECPSignature decode(Bytes bytes, BigInteger curveOrder) {
        Preconditions.checkArgument((bytes.size() == 65 ? 1 : 0) != 0, (Object)"encoded SECP256K1 signature must be 65 bytes long");
        BigInteger r = bytes.slice(0, 32).toUnsignedBigInteger();
        BigInteger s = bytes.slice(32, 32).toUnsignedBigInteger();
        byte recId = bytes.get(64);
        return SECPSignature.create(r, s, recId, curveOrder);
    }

    public Bytes encodedBytes() {
        return this.encoded.get();
    }

    private Bytes _encodedBytes() {
        MutableBytes bytes = MutableBytes.create((int)65);
        UInt256.valueOf((BigInteger)this.r).copyTo(bytes, 0);
        UInt256.valueOf((BigInteger)this.s).copyTo(bytes, 32);
        bytes.set(64, this.recId);
        return bytes;
    }

    public boolean equals(Object other) {
        if (!(other instanceof SECPSignature)) {
            return false;
        }
        SECPSignature that = (SECPSignature)other;
        return this.r.equals(that.r) && this.s.equals(that.s) && this.recId == that.recId;
    }

    public int hashCode() {
        return Objects.hash(this.r, this.s, this.recId);
    }

    public byte getRecId() {
        return this.recId;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Signature").append("{");
        sb.append("r=").append(this.r).append(", ");
        sb.append("s=").append(this.s).append(", ");
        sb.append("recId=").append(this.recId);
        return sb.append("}").toString();
    }
}

