/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.serialize;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;

public interface BaseSerializer<T> {
    public static final int VARIABLE_DATA_SIZE = -1;

    public long getCurrentDataVersion();

    default public boolean isVariableSize() {
        return this.getSerializedSize() == -1;
    }

    public int getSerializedSize();

    @Deprecated
    default public int getSerializedSizeForVersion(long version) {
        return this.getSerializedSize();
    }

    default public int getTypicalSerializedSize() {
        if (this.isVariableSize()) {
            throw new IllegalStateException("Variable sized implementations have to override this method");
        }
        return this.getSerializedSize();
    }

    default public int getSerializedSize(@NonNull T data) {
        Objects.requireNonNull(data);
        int size = this.getSerializedSize();
        if (size != -1) {
            return size;
        }
        throw new RuntimeException("TO IMPLEMENT: " + this.getClass().getSimpleName() + ".getSerializedSize()");
    }

    public void serialize(@NonNull T var1, @NonNull WritableSequentialData var2);

    default public Bytes toBytes(@NonNull T data) {
        Bytes bytes;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            WritableStreamingData out = new WritableStreamingData((OutputStream)bout);
            this.serialize(data, (WritableSequentialData)out);
            byte[] bytes2 = bout.toByteArray();
            if (!1.$assertionsDisabled && bytes2.length != this.getSerializedSize(data)) {
                throw new AssertionError();
            }
            bytes = Bytes.wrap((byte[])bytes2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bout.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        bout.close();
        return bytes;
    }

    public T deserialize(@NonNull ReadableSequentialData var1);

    default public T fromBytes(@NonNull Bytes b) {
        return this.deserialize(b.toReadableSequentialData());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

