/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.node.app.service.networkadmin.impl.ReadableFreezeStoreImpl;
import com.hedera.node.app.service.networkadmin.impl.schemas.V0490FreezeSchema;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class WritableFreezeStore
extends ReadableFreezeStoreImpl {
    private final WritableSingletonState<Timestamp> freezeTimeState;
    private final WritableSingletonState<ProtoBytes> updateFileHash;

    public WritableFreezeStore(@NonNull WritableStates states) {
        super((ReadableStates)states);
        Objects.requireNonNull(states);
        this.freezeTimeState = states.getSingleton(V0490FreezeSchema.FREEZE_TIME_STATE_ID);
        this.updateFileHash = states.getSingleton(V0490FreezeSchema.UPGRADE_FILE_HASH_STATE_ID);
    }

    public void freezeTime(@NonNull Timestamp freezeTime) {
        this.freezeTimeState.put((Object)freezeTime);
    }

    @Override
    @Nullable
    public Timestamp freezeTime() {
        return Timestamp.DEFAULT.equals(this.freezeTimeState.get()) ? null : (Timestamp)this.freezeTimeState.get();
    }

    public void updateFileHash(@NonNull Bytes updateFileHashBytes) {
        Objects.requireNonNull(updateFileHashBytes);
        this.updateFileHash.put((Object)new ProtoBytes(updateFileHashBytes));
    }

    @Override
    @Nullable
    public Bytes updateFileHash() {
        return WritableFreezeStore.effectiveUpdateFileHash((ProtoBytes)this.updateFileHash.get());
    }

    @Nullable
    static Bytes effectiveUpdateFileHash(@Nullable ProtoBytes fileHash) {
        if (fileHash == null) {
            return null;
        }
        return Bytes.EMPTY.equals((Object)fileHash.value()) ? null : fileHash.value();
    }
}

