/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl;

import com.hedera.node.app.service.contract.impl.ContractServiceModule;
import com.hedera.node.app.service.contract.impl.annotations.CustomOps;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategies;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.has.HasCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.handlers.ContractHandlers;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import dagger.BindsInstance;
import dagger.Component;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.InstantSource;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.tracing.OperationTracer;

@Singleton
@Component(modules={ContractServiceModule.class})
public interface ContractServiceComponent {
    public ContractHandlers handlers();

    public ContractMetrics contractMetrics();

    public SystemContractMethodRegistry systemContractMethodRegistry();

    @Named(value="HasTranslators")
    public Provider<List<CallTranslator<HasCallAttempt>>> hasCallTranslators();

    @Named(value="HssTranslators")
    public Provider<List<CallTranslator<HssCallAttempt>>> hssCallTranslators();

    @Named(value="HtsTranslators")
    public Provider<List<CallTranslator<HtsCallAttempt>>> htsCallTranslators();

    @Component.Factory
    public static interface Factory {
        public ContractServiceComponent create(@BindsInstance InstantSource var1, @BindsInstance SignatureVerifier var2, @BindsInstance VerificationStrategies var3, @BindsInstance @Nullable Supplier<List<OperationTracer>> var4, @BindsInstance ContractMetrics var5, @BindsInstance SystemContractMethodRegistry var6, @BindsInstance @CustomOps Set<Operation> var7, @BindsInstance EntityIdFactory var8);
    }
}

