/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.streams.SidecarType;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.config.data.ContractsConfig;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface FeatureFlags {
    public boolean isCreate2Enabled(@NonNull MessageFrame var1);

    default public boolean isSidecarEnabled(@NonNull MessageFrame frame, @NonNull SidecarType sidecarType) {
        return FrameUtils.contractsConfigOf(frame).sidecars().contains(sidecarType);
    }

    public boolean isImplicitCreationEnabled();

    default public boolean isAllowCallsToNonContractAccountsEnabled(@NonNull ContractsConfig config, @Nullable Long possiblyGrandFatheredEntityNum) {
        return false;
    }

    default public boolean isChargeGasOnPreEvmException(@NonNull Configuration config) {
        return false;
    }

    default public boolean isHederaAccountServiceEnabled(@NonNull Configuration config) {
        return false;
    }

    default public boolean isAuthorizedRawMethodEnabled(@NonNull Configuration config) {
        return false;
    }
}

