/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.gas;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.service.contract.impl.exec.gas.GasCharges;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@Singleton
public class CustomGasCharging {
    public static final long ONE_HBAR_IN_TINYBARS = 100000000L;
    private final GasCalculator gasCalculator;

    @Inject
    public CustomGasCharging(@NonNull GasCalculator gasCalculator) {
        this.gasCalculator = gasCalculator;
    }

    public void maybeRefundGiven(long unusedGas, long allowanceUsed, @NonNull HederaEvmAccount sender, @Nullable HederaEvmAccount relayer, @NonNull HederaEvmContext context, @NonNull HederaWorldUpdater worldUpdater) {
        Objects.requireNonNull(sender);
        Objects.requireNonNull(context);
        Objects.requireNonNull(worldUpdater);
        if (context.isNoopGasContext() || unusedGas == 0L) {
            return;
        }
        long refund = unusedGas * context.gasPrice();
        if (allowanceUsed > 0L) {
            Objects.requireNonNull(relayer);
            worldUpdater.refundGasFee(relayer.hederaId(), Math.min(allowanceUsed, refund));
            if (refund > allowanceUsed) {
                worldUpdater.refundGasFee(sender.hederaId(), refund - allowanceUsed);
            }
        } else {
            worldUpdater.refundGasFee(sender.hederaId(), refund);
        }
    }

    public GasCharges chargeForGas(@NonNull HederaEvmAccount sender, @Nullable HederaEvmAccount relayer, @NonNull HederaEvmContext context, @NonNull HederaWorldUpdater worldUpdater, @NonNull HederaEvmTransaction transaction) {
        Objects.requireNonNull(sender);
        Objects.requireNonNull(context);
        Objects.requireNonNull(worldUpdater);
        Objects.requireNonNull(transaction);
        long intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(transaction.evmPayload(), transaction.isCreate());
        if (context.isNoopGasContext()) {
            return new GasCharges(intrinsicGas, 0L);
        }
        HandleException.validateTrue((transaction.gasLimit() >= intrinsicGas ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        if (transaction.isEthereumTransaction()) {
            Objects.requireNonNull(relayer);
            long allowanceUsed = this.chargeWithRelayer(sender, relayer, context, worldUpdater, transaction);
            sender.incrementNonce();
            return new GasCharges(intrinsicGas, allowanceUsed);
        }
        this.chargeWithOnlySender(sender, context, worldUpdater, transaction);
        return new GasCharges(intrinsicGas, 0L);
    }

    public void chargeGasForAbortedTransaction(@NonNull AccountID sender, @NonNull HederaEvmContext context, @NonNull HederaWorldUpdater worldUpdater, @NonNull HederaEvmTransaction transaction) {
        Objects.requireNonNull(sender);
        Objects.requireNonNull(context);
        Objects.requireNonNull(worldUpdater);
        Objects.requireNonNull(transaction);
        long intrinsicGas = this.gasCalculator.transactionIntrinsicGasCost(transaction.evmPayload(), false);
        if (transaction.isEthereumTransaction()) {
            long fee = this.feeForAborted(transaction.relayerId(), context, worldUpdater, intrinsicGas);
            worldUpdater.collectGasFee(transaction.relayerId(), fee, false);
        } else {
            long fee = this.feeForAborted(sender, context, worldUpdater, intrinsicGas);
            worldUpdater.collectGasFee(sender, fee, false);
        }
    }

    private long feeForAborted(@NonNull AccountID accountID, @NonNull HederaEvmContext context, @NonNull HederaWorldUpdater worldUpdater, long intrinsicGas) {
        Objects.requireNonNull(accountID);
        Objects.requireNonNull(context);
        Objects.requireNonNull(worldUpdater);
        HederaEvmAccount hederaAccount = worldUpdater.getHederaAccount(accountID);
        Objects.requireNonNull(hederaAccount);
        long fee = Math.min(this.gasCostGiven(intrinsicGas, context.gasPrice()), hederaAccount.getBalance().toLong());
        long protectedFee = Math.min(fee, 100000000L);
        HandleException.validateTrue((hederaAccount.getBalance().toLong() >= protectedFee ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
        return protectedFee;
    }

    private void chargeWithOnlySender(@NonNull HederaEvmAccount sender, @NonNull HederaEvmContext context, @NonNull HederaWorldUpdater worldUpdater, @NonNull HederaEvmTransaction transaction) {
        HandleException.validateTrue((sender.getBalance().toLong() >= transaction.upfrontCostGiven(context.gasPrice()) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
        worldUpdater.collectGasFee(sender.hederaId(), transaction.gasCostGiven(context.gasPrice()), false);
    }

    private long chargeWithRelayer(@NonNull HederaEvmAccount sender, @NonNull HederaEvmAccount relayer, @NonNull HederaEvmContext context, @NonNull HederaWorldUpdater worldUpdater, @NonNull HederaEvmTransaction transaction) {
        long relayerGasCost;
        long senderGasCost;
        long gasCost = transaction.gasCostGiven(context.gasPrice());
        if (transaction.requiresFullRelayerAllowance()) {
            senderGasCost = 0L;
            relayerGasCost = gasCost;
        } else if (transaction.offeredGasPrice() >= context.gasPrice()) {
            senderGasCost = gasCost;
            relayerGasCost = 0L;
        } else {
            senderGasCost = transaction.offeredGasCost();
            relayerGasCost = gasCost - transaction.offeredGasCost();
        }
        HandleException.validateTrue((transaction.maxGasAllowance() >= relayerGasCost ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_TX_FEE);
        HandleException.validateTrue((relayer.getBalance().toLong() >= relayerGasCost ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
        HandleException.validateTrue((sender.getBalance().toLong() >= senderGasCost + transaction.value() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE);
        worldUpdater.collectGasFee(relayer.hederaId(), relayerGasCost, false);
        worldUpdater.collectGasFee(sender.hederaId(), senderGasCost, true);
        return relayerGasCost;
    }

    public long gasCostGiven(long gasCharge, long gasPrice) {
        try {
            return Math.multiplyExact(gasCharge, gasPrice);
        }
        catch (ArithmeticException ignore) {
            return Long.MAX_VALUE;
        }
    }
}

