/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations.utils;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.infra.StorageAccessTracker;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class OpUtils {
    private OpUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void maybeTrackReadIn(@NonNull MessageFrame frame, @NonNull UInt256 key, @NonNull UInt256 value) {
        StorageAccessTracker accessTracker = FrameUtils.accessTrackerFor(frame);
        if (accessTracker != null) {
            ProxyWorldUpdater worldUpdater = FrameUtils.proxyUpdaterFor(frame);
            ContractID contractId = worldUpdater.getHederaContractId(frame.getRecipientAddress());
            accessTracker.trackIfFirstRead(contractId, key, value);
        }
    }
}

