/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.processors;

import com.hedera.hapi.block.stream.trace.ExecutedInitcode;
import com.hedera.hapi.block.stream.trace.InitcodeBookends;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.PendingCreationMetadata;
import com.hedera.node.app.service.contract.impl.state.AbstractProxyEvmAccount;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.processor.ContractCreationProcessor;
import org.hyperledger.besu.evm.tracing.OperationTracer;

public class CustomContractCreationProcessor
extends ContractCreationProcessor {
    private static final Optional<ExceptionalHaltReason> COLLISION_HALT_REASON = Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS);
    private static final Optional<ExceptionalHaltReason> ENTITY_LIMIT_HALT_REASON = Optional.of(CustomExceptionalHaltReason.CONTRACT_ENTITY_LIMIT_REACHED);
    private static final Optional<ExceptionalHaltReason> CHILD_RECORDS_LIMIT_HALT_REASON = Optional.of(CustomExceptionalHaltReason.INSUFFICIENT_CHILD_RECORDS);

    public CustomContractCreationProcessor(@NonNull EVM evm, @NonNull GasCalculator gasCalculator, boolean requireCodeDepositToSucceed, @NonNull List<ContractValidationRule> contractValidationRules, long initialContractNonce) {
        super(Objects.requireNonNull(gasCalculator), Objects.requireNonNull(evm), requireCodeDepositToSucceed, Objects.requireNonNull(contractValidationRules), initialContractNonce);
    }

    public void start(@NonNull MessageFrame frame, @NonNull OperationTracer tracer) {
        MutableAccount contract;
        Address addressToCreate = frame.getContractAddress();
        try {
            contract = frame.getWorldUpdater().getOrCreate(addressToCreate);
        }
        catch (ResourceExhaustedException e) {
            this.haltOnResourceExhaustion(frame, tracer, e);
            return;
        }
        if (this.alreadyCreated(contract)) {
            this.halt(frame, tracer, COLLISION_HALT_REASON);
        } else {
            Optional<ExceptionalHaltReason> maybeReasonToHalt;
            ProxyWorldUpdater updater = FrameUtils.proxyUpdaterFor(frame);
            if (this.isHollow(contract)) {
                updater.finalizeHollowAccount(addressToCreate, frame.getSenderAddress());
            }
            if ((maybeReasonToHalt = updater.tryTransfer(frame.getSenderAddress(), addressToCreate, frame.getValue().toLong(), false)).isPresent()) {
                this.halt(frame, tracer, maybeReasonToHalt);
            } else {
                contract.setNonce(1L);
                frame.addCreate(addressToCreate);
                frame.setState(MessageFrame.State.CODE_EXECUTING);
            }
        }
    }

    private void haltOnResourceExhaustion(@NonNull MessageFrame frame, @NonNull OperationTracer tracer, @NonNull ResourceExhaustedException e) {
        switch (e.getStatus()) {
            case MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED: {
                this.halt(frame, tracer, ENTITY_LIMIT_HALT_REASON);
                break;
            }
            case MAX_CHILD_RECORDS_EXCEEDED: {
                this.halt(frame, tracer, CHILD_RECORDS_LIMIT_HALT_REASON);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected creation failure reason", e);
            }
        }
    }

    public void codeSuccess(@NonNull MessageFrame frame, @NonNull OperationTracer tracer) {
        boolean validationRuleFailed;
        super.codeSuccess(Objects.requireNonNull(frame), Objects.requireNonNull(tracer));
        boolean bl = validationRuleFailed = frame.getState() == MessageFrame.State.EXCEPTIONAL_HALT;
        if (FrameUtils.hasBytecodeSidecarsEnabled(frame)) {
            Bytes initcode;
            HederaEvmAccount recipient = FrameUtils.proxyUpdaterFor(frame).getHederaAccount(frame.getRecipientAddress());
            ContractID recipientId = Objects.requireNonNull(recipient).hederaContractId();
            PendingCreationMetadata pendingCreationMetadata = FrameUtils.getAndClearPendingCreationMetadata(frame, recipientId);
            Bytes bytecode = ConversionUtils.tuweniToPbjBytes(recipient.getCode());
            Bytes bytes = initcode = pendingCreationMetadata.needsInitcodeExternalized() ? ConversionUtils.tuweniToPbjBytes(frame.getCode().getBytes()) : null;
            if (validationRuleFailed) {
                if (initcode != null) {
                    sidecar = ContractBytecode.newBuilder().initcode(initcode).build();
                    pendingCreationMetadata.streamBuilder().addContractBytecode((ContractBytecode)sidecar, false);
                }
            } else {
                sidecar = ContractBytecode.newBuilder().contractId(recipientId).runtimeBytecode(bytecode);
                if (initcode != null) {
                    sidecar.initcode(initcode);
                }
                pendingCreationMetadata.streamBuilder().addContractBytecode(sidecar.build(), false);
            }
            if (!validationRuleFailed && initcode != null) {
                ExecutedInitcode.Builder initcodeBuilder = ExecutedInitcode.newBuilder().contractId(recipientId);
                int i = CustomContractCreationProcessor.indexOf(initcode, bytecode);
                if (i != -1) {
                    Bytes leftBookend = initcode.slice(0L, (long)i);
                    int rightIndex = i + (int)bytecode.length();
                    Bytes rightBookend = initcode.slice((long)rightIndex, (long)((int)initcode.length() - rightIndex));
                    initcodeBuilder.initcodeBookends(new InitcodeBookends(leftBookend, rightBookend));
                } else {
                    initcodeBuilder.explicitInitcode(initcode);
                }
                pendingCreationMetadata.streamBuilder().addInitcode(initcodeBuilder.build());
            }
        }
    }

    private void halt(@NonNull MessageFrame frame, @NonNull OperationTracer tracer, @NonNull Optional<ExceptionalHaltReason> reason) {
        frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
        frame.setExceptionalHaltReason(reason);
        tracer.traceAccountCreationResult(frame, reason);
    }

    private boolean alreadyCreated(MutableAccount account) {
        return account.getNonce() > 0L || account.getCode().size() > 0;
    }

    private boolean isHollow(@NonNull MutableAccount account) {
        if (account instanceof AbstractProxyEvmAccount) {
            AbstractProxyEvmAccount abstractProxyEvmAccount = (AbstractProxyEvmAccount)account;
            return abstractProxyEvmAccount.isHollow();
        }
        throw new IllegalArgumentException("Creation target not a AbstractProxyEvmAccount - " + String.valueOf(account));
    }

    private static int indexOf(@NonNull Bytes haystackBytes, @NonNull Bytes needleBytes) {
        Objects.requireNonNull(haystackBytes);
        Objects.requireNonNull(needleBytes);
        byte[] haystack = haystackBytes.toByteArray();
        byte[] needle = needleBytes.toByteArray();
        if (needle.length == 0) {
            return 0;
        }
        if (needle.length > haystack.length) {
            return -1;
        }
        byte firstByte = needle[0];
        for (int i = 0; i <= haystack.length - needle.length; ++i) {
            if (haystack[i] != firstByte || Arrays.mismatch(haystack, i, i + needle.length, needle, 0, needle.length) >= 0) continue;
            return i;
        }
        return -1;
    }
}

