/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.has;

import com.esaulpaugh.headlong.abi.Function;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAttemptOptions;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.node.config.data.HederaConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;

public class HasCallAttempt
extends AbstractCallAttempt<HasCallAttempt> {
    public static final Function REDIRECT_FOR_ACCOUNT = new Function("redirectForAccount(address,bytes)");
    @Nullable
    private final Account redirectAccount;
    @NonNull
    private final SignatureVerifier signatureVerifier;

    public HasCallAttempt(@NonNull Bytes input, @NonNull CallAttemptOptions<HasCallAttempt> options, @NonNull SignatureVerifier signatureVerifier) {
        super(input, options, REDIRECT_FOR_ACCOUNT);
        this.redirectAccount = this.isRedirect() ? this.linkedAccount(Objects.requireNonNull(this.redirectAddress)) : null;
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
    }

    @Override
    protected SystemContractMethod.SystemContract systemContractKind() {
        return SystemContractMethod.SystemContract.HAS;
    }

    @Override
    protected HasCallAttempt self() {
        return this;
    }

    @Nullable
    public Account redirectAccount() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not an account redirect");
        }
        return this.redirectAccount;
    }

    @Nullable
    public AccountID redirectAccountId() {
        if (!this.isRedirect()) {
            throw new IllegalStateException("Not a account redirect");
        }
        return this.redirectAccount == null ? null : this.redirectAccount.accountId();
    }

    @Nullable
    public Account linkedAccount(@NonNull Address accountAddress) {
        Objects.requireNonNull(accountAddress);
        if (ConversionUtils.isLongZero(accountAddress)) {
            return this.enhancement().nativeOperations().getAccount(this.nativeOperations().entityIdFactory().newAccountId(ConversionUtils.numberOfLongZero(accountAddress.toArray())));
        }
        HederaConfig config = (HederaConfig)this.configuration().getConfigData(HederaConfig.class);
        long addressNum = this.enhancement().nativeOperations().resolveAlias(config.shard(), config.realm(), com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])accountAddress.toArray()));
        return this.enhancement().nativeOperations().getAccount(this.nativeOperations().entityIdFactory().newAccountId(addressNum));
    }

    @NonNull
    public SignatureVerifier signatureVerifier() {
        return this.signatureVerifier;
    }
}

