/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.getapproved;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.getapproved.GetApprovedCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GetApprovedTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod HAPI_GET_APPROVED = SystemContractMethod.declare("getApproved(address,uint256)", "(int32,address)").withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.TOKEN_QUERY, SystemContractMethod.Category.APPROVAL);
    public static final SystemContractMethod ERC_GET_APPROVED = SystemContractMethod.declare("getApproved(uint256)", "(address)").withVia(SystemContractMethod.CallVia.PROXY).withModifier(SystemContractMethod.Modifier.VIEW).withCategories(SystemContractMethod.Category.ERC721, SystemContractMethod.Category.TOKEN_QUERY, SystemContractMethod.Category.APPROVAL);

    @Inject
    public GetApprovedTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(HAPI_GET_APPROVED, ERC_GET_APPROVED);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isRedirect() ? attempt.isMethod(ERC_GET_APPROVED) : attempt.isMethod(HAPI_GET_APPROVED);
    }

    public GetApprovedCall callFrom(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(ERC_GET_APPROVED)) {
            Tuple args = ERC_GET_APPROVED.decodeCall(attempt.input().toArrayUnsafe());
            return new GetApprovedCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.redirectToken(), ConversionUtils.asExactLongValueOrZero((BigInteger)args.get(0)), true, attempt.isStaticCall());
        }
        Tuple args = HAPI_GET_APPROVED.decodeCall(attempt.input().toArrayUnsafe());
        Token token = attempt.linkedToken(ConversionUtils.fromHeadlongAddress((Address)args.get(0)));
        return new GetApprovedCall(attempt.systemContractGasCalculator(), attempt.enhancement(), token, ConversionUtils.asExactLongValueOrZero((BigInteger)args.get(1)), false, attempt.isStaticCall());
    }
}

