/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.AddressIdConverter;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.utils.KeyValueWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenExpiryWrapper;
import com.hedera.node.app.service.contract.impl.exec.utils.TokenKeyWrapper;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public abstract class UpdateCommonDecoder {
    public static final DispatchForResponseCodeHtsCall.FailureCustomizer FAILURE_CUSTOMIZER = (body, code, enhancement) -> {
        if (code == ResponseCodeEnum.INVALID_ACCOUNT_ID) {
            ReadableAccountStore accountStore;
            Account maybeTreasury;
            TokenUpdateTransactionBody op = body.tokenUpdateOrThrow();
            if (op.hasTreasury() && (maybeTreasury = (accountStore = enhancement.nativeOperations().readableAccountStore()).getAccountById(op.treasuryOrThrow())) == null) {
                return ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN;
            }
        } else if (code == ResponseCodeEnum.INVALID_SIGNATURE) {
            TokenUpdateTransactionBody op = body.tokenUpdateOrThrow();
            ReadableTokenStore tokenStore = enhancement.nativeOperations().readableTokenStore();
            if (UpdateCommonDecoder.isKnownImmutable(tokenStore.get(op.tokenOrElse(TokenID.DEFAULT)))) {
                return ResponseCodeEnum.TOKEN_IS_IMMUTABLE;
            }
        }
        return code;
    };
    protected static final int TOKEN_ADDRESS = 0;
    protected static final int HEDERA_TOKEN = 1;
    protected static final int EXPIRY = 1;
    protected static final int TOKEN_KEYS = 1;
    protected static final int KEY_TYPE = 0;
    protected static final int KEY_VALUE = 1;
    protected static final int SERIAL_NUMBERS = 1;
    protected static final int METADATA = 2;
    protected static final int INHERIT_ACCOUNT_KEY = 0;
    protected static final int CONTRACT_ID = 1;
    protected static final int ED25519 = 2;
    protected static final int ECDSA_SECP_256K1 = 3;
    protected static final int DELEGATABLE_CONTRACT_ID = 4;

    private static boolean isKnownImmutable(@Nullable Token token) {
        return token != null && KeyUtils.IMMUTABILITY_SENTINEL_KEY.equals((Object)token.adminKeyOrElse(KeyUtils.IMMUTABILITY_SENTINEL_KEY));
    }

    protected TokenUpdateTransactionBody.Builder decodeTokenUpdate(@NonNull Tuple call, @NonNull AddressIdConverter addressIdConverter, @NonNull HederaNativeOperations nativeOperation) {
        TokenID tokenId = ConversionUtils.asTokenId(nativeOperation.entityIdFactory(), (Address)call.get(0));
        Tuple hederaToken = (Tuple)call.get(1);
        String tokenName = (String)hederaToken.get(0);
        String tokenSymbol = (String)hederaToken.get(1);
        AccountID tokenTreasury = addressIdConverter.convert((Address)hederaToken.get(2));
        String memo = (String)hederaToken.get(3);
        List<TokenKeyWrapper> tokenKeys = this.decodeTokenKeys((Tuple[])hederaToken.get(7), addressIdConverter, nativeOperation);
        TokenExpiryWrapper tokenExpiry = this.decodeTokenExpiry((Tuple)hederaToken.get(8), addressIdConverter);
        TokenUpdateTransactionBody.Builder txnBodyBuilder = TokenUpdateTransactionBody.newBuilder();
        txnBodyBuilder.token(tokenId);
        if (tokenName != null) {
            txnBodyBuilder.name(tokenName);
        }
        if (tokenSymbol != null) {
            txnBodyBuilder.symbol(tokenSymbol);
        }
        if (memo != null) {
            txnBodyBuilder.memo(memo);
        }
        txnBodyBuilder.treasury(tokenTreasury);
        if (tokenExpiry.second() != 0L) {
            txnBodyBuilder.expiry(Timestamp.newBuilder().seconds(tokenExpiry.second()).build());
        }
        if (tokenExpiry.autoRenewAccount() != null) {
            txnBodyBuilder.autoRenewAccount(tokenExpiry.autoRenewAccount());
        }
        if (tokenExpiry.autoRenewPeriod() != null && tokenExpiry.autoRenewPeriod().seconds() != 0L) {
            txnBodyBuilder.autoRenewPeriod(tokenExpiry.autoRenewPeriod());
        }
        this.addKeys(tokenKeys, txnBodyBuilder);
        return txnBodyBuilder;
    }

    protected List<TokenKeyWrapper> decodeTokenKeys(@NonNull Tuple[] tokenKeysTuples, @NonNull AddressIdConverter addressIdConverter, @NonNull HederaNativeOperations nativeOperation) {
        ArrayList<TokenKeyWrapper> tokenKeys = new ArrayList<TokenKeyWrapper>(tokenKeysTuples.length);
        for (Tuple tokenKeyTuple : tokenKeysTuples) {
            int keyType = ((BigInteger)tokenKeyTuple.get(0)).intValue();
            Tuple keyValueTuple = (Tuple)tokenKeyTuple.get(1);
            Boolean inheritAccountKey = (Boolean)keyValueTuple.get(0);
            byte[] ed25519 = (byte[])keyValueTuple.get(2);
            byte[] ecdsaSecp256K1 = (byte[])keyValueTuple.get(3);
            EntityIdFactory entityIdFactory = nativeOperation.entityIdFactory();
            ContractID contractId = ConversionUtils.asNumericContractId(entityIdFactory, addressIdConverter.convert((Address)keyValueTuple.get(1)));
            ContractID delegatableContractId = ConversionUtils.asNumericContractId(entityIdFactory, addressIdConverter.convert((Address)keyValueTuple.get(4)));
            tokenKeys.add(new TokenKeyWrapper(keyType, new KeyValueWrapper(inheritAccountKey, (ContractID)(contractId.contractNumOrThrow() != 0L ? contractId : null), ed25519, ecdsaSecp256K1, (ContractID)(delegatableContractId.contractNumOrThrow() != 0L ? delegatableContractId : null))));
        }
        return tokenKeys;
    }

    @Nullable
    public TransactionBody decodeTokenUpdateKeys(@NonNull HtsCallAttempt attempt) {
        Tuple call = this.decodeCall(attempt);
        TokenID tokenId = ConversionUtils.asTokenId(attempt.nativeOperations().entityIdFactory(), (Address)call.get(0));
        List<TokenKeyWrapper> tokenKeys = this.decodeTokenKeys((Tuple[])call.get(1), attempt.addressIdConverter(), attempt.nativeOperations());
        TokenUpdateTransactionBody.Builder txnBodyBuilder = TokenUpdateTransactionBody.newBuilder();
        txnBodyBuilder.token(tokenId);
        this.addKeys(tokenKeys, txnBodyBuilder);
        try {
            return TransactionBody.newBuilder().tokenUpdate(txnBodyBuilder).build();
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    protected abstract Tuple decodeCall(@NonNull HtsCallAttempt var1);

    protected void addKeys(List<TokenKeyWrapper> tokenKeys, TokenUpdateTransactionBody.Builder builder) {
        tokenKeys.forEach(tokenKeyWrapper -> {
            Key key = tokenKeyWrapper.key().asGrpc();
            if (key == Key.DEFAULT) {
                throw new IllegalArgumentException();
            }
            this.setUsedKeys(builder, (TokenKeyWrapper)tokenKeyWrapper, key);
        });
    }

    private void setUsedKeys(TokenUpdateTransactionBody.Builder builder, TokenKeyWrapper tokenKeyWrapper, Key key) {
        if (tokenKeyWrapper.isUsedForAdminKey()) {
            builder.adminKey(key);
        }
        if (tokenKeyWrapper.isUsedForKycKey()) {
            builder.kycKey(key);
        }
        if (tokenKeyWrapper.isUsedForFreezeKey()) {
            builder.freezeKey(key);
        }
        if (tokenKeyWrapper.isUsedForWipeKey()) {
            builder.wipeKey(key);
        }
        if (tokenKeyWrapper.isUsedForSupplyKey()) {
            builder.supplyKey(key);
        }
        if (tokenKeyWrapper.isUsedForFeeScheduleKey()) {
            builder.feeScheduleKey(key);
        }
        if (tokenKeyWrapper.isUsedForPauseKey()) {
            builder.pauseKey(key);
        }
    }

    protected TokenExpiryWrapper decodeTokenExpiry(@NonNull Tuple expiryTuple, @NonNull AddressIdConverter addressIdConverter) {
        long second = (Long)expiryTuple.get(0);
        AccountID autoRenewAccount = addressIdConverter.convert((Address)expiryTuple.get(1));
        Duration autoRenewPeriod = Duration.newBuilder().seconds(((Long)expiryTuple.get(2)).longValue()).build();
        return new TokenExpiryWrapper(second, autoRenewAccount.accountNumOrElse(Long.valueOf(0L)) == 0L ? null : autoRenewAccount, autoRenewPeriod);
    }
}

