/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.wipe;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.wipe.WipeDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WipeTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod WIPE_FUNGIBLE_V1 = SystemContractMethod.declare("wipeTokenAccount(address,address,uint32)", "(int)").withVariants(SystemContractMethod.Variant.V1, SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.WIPE);
    public static final SystemContractMethod WIPE_FUNGIBLE_V2 = SystemContractMethod.declare("wipeTokenAccount(address,address,int64)", "(int)").withVariants(SystemContractMethod.Variant.V2, SystemContractMethod.Variant.FT).withCategories(SystemContractMethod.Category.WIPE);
    public static final SystemContractMethod WIPE_NFT = SystemContractMethod.declare("wipeTokenAccountNFT(address,address,int64[])", "(int)").withVariant(SystemContractMethod.Variant.NFT).withCategories(SystemContractMethod.Category.WIPE);
    private final WipeDecoder decoder;

    @Inject
    public WipeTranslator(@NonNull WipeDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(WIPE_FUNGIBLE_V1, WIPE_FUNGIBLE_V2, WIPE_NFT);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        return attempt.isMethod(WIPE_FUNGIBLE_V1, WIPE_FUNGIBLE_V2, WIPE_NFT);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        TransactionBody body;
        boolean isFungibleWipe = (body = this.bodyForClassic(attempt)).tokenWipeOrThrow().serialNumbers().isEmpty();
        return new DispatchForResponseCodeHtsCall(attempt, body, isFungibleWipe ? WipeTranslator::fungibleWipeGasRequirement : WipeTranslator::nftWipeGasRequirement, DispatchForResponseCodeHtsCall.FailureCustomizer.NOOP_CUSTOMIZER);
    }

    public static long fungibleWipeGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.WIPE_FUNGIBLE, payerId);
    }

    public static long nftWipeGasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.WIPE_NFT, payerId);
    }

    private TransactionBody bodyForClassic(@NonNull HtsCallAttempt attempt) {
        if (attempt.isSelector(WIPE_FUNGIBLE_V1)) {
            return this.decoder.decodeWipeFungibleV1(attempt);
        }
        if (attempt.isSelector(WIPE_FUNGIBLE_V2)) {
            return this.decoder.decodeWipeFungibleV2(attempt);
        }
        return this.decoder.decodeWipeNonFungible(attempt);
    }
}

