/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.contract.ContractGetBytecodeQuery;
import com.hedera.hapi.node.contract.ContractGetBytecodeResponse;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SmartContractFeeBuilder;
import com.hedera.node.app.service.contract.impl.handlers.AbstractContractPaidQueryHandler;
import com.hedera.node.app.service.contract.impl.state.ContractStateStore;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.RedirectBytecodeUtils;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ContractGetBytecodeHandler
extends AbstractContractPaidQueryHandler<ContractGetBytecodeQuery> {
    private final SmartContractFeeBuilder feeBuilder = new SmartContractFeeBuilder();

    @Inject
    public ContractGetBytecodeHandler(@NonNull EntityIdFactory entityIdFactory) {
        super(entityIdFactory, Query::contractGetBytecodeOrThrow, e -> e.contractIDOrElse(ContractID.DEFAULT));
    }

    public QueryHeader extractHeader(@NonNull Query query) {
        Objects.requireNonNull(query);
        return query.contractGetBytecodeOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        ContractGetBytecodeResponse.Builder response = ContractGetBytecodeResponse.newBuilder().header(header);
        return Response.newBuilder().contractGetBytecodeResponse(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ContractID contractId = this.getContractId(context);
        if (contractId == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_CONTRACT_ID);
        }
        Account contract = this.accountFrom(context, contractId);
        if (contract != null) {
            if (contract.deleted()) {
                throw new PreCheckException(ResponseCodeEnum.CONTRACT_DELETED);
            }
        } else {
            Token token = this.tokenFrom(context, contractId);
            if (token != null) {
                if (token.deleted()) {
                    throw new PreCheckException(ResponseCodeEnum.CONTRACT_DELETED);
                }
            } else {
                Schedule schedule = this.scheduleFrom(context, contractId);
                if (schedule != null) {
                    if (schedule.deleted()) {
                        throw new PreCheckException(ResponseCodeEnum.CONTRACT_DELETED);
                    }
                } else {
                    throw new PreCheckException(ResponseCodeEnum.INVALID_CONTRACT_ID);
                }
            }
        }
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Bytes effectiveBytecode;
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        ContractGetBytecodeResponse.Builder contractGetBytecode = ContractGetBytecodeResponse.newBuilder().header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && header.responseType() == ResponseType.ANSWER_ONLY && (effectiveBytecode = this.bytecodeFrom(context)) != null) {
            contractGetBytecode.bytecode(effectiveBytecode);
        }
        return Response.newBuilder().contractGetBytecodeResponse(contractGetBytecode).build();
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext context) {
        Bytes effectiveBytecode = this.bytecodeFrom(context);
        if (effectiveBytecode == null) {
            effectiveBytecode = Bytes.EMPTY;
        }
        ContractGetBytecodeQuery op = (ContractGetBytecodeQuery)this.getOperation(context);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        FeeData usage = this.feeBuilder.getContractByteCodeQueryFeeMatrices((int)effectiveBytecode.length(), CommonPbjConverters.fromPbjResponseType((ResponseType)responseType));
        return context.feeCalculator().legacyCalculate(sigValueObj -> usage);
    }

    private Bytes bytecodeFrom(@NonNull QueryContext context) {
        ContractID contractId = this.getContractId(context);
        if (contractId == null) {
            return null;
        }
        Account account = this.accountFrom(context, contractId);
        if (account != null) {
            if (account.deleted()) {
                return null;
            }
            if (account.smartContract()) {
                return this.bytecodeFrom(context, account);
            }
            return RedirectBytecodeUtils.accountProxyBytecodePjb(ConversionUtils.contractIDToBesuAddress(this.entityIdFactory, contractId));
        }
        Token token = this.tokenFrom(context, contractId);
        if (token != null) {
            if (token.deleted()) {
                return null;
            }
            return RedirectBytecodeUtils.tokenProxyBytecodePjb(ConversionUtils.contractIDToBesuAddress(this.entityIdFactory, contractId));
        }
        Schedule schedule = this.scheduleFrom(context, contractId);
        if (schedule != null) {
            if (schedule.deleted()) {
                return null;
            }
            return RedirectBytecodeUtils.scheduleProxyBytecodePjb(ConversionUtils.contractIDToBesuAddress(this.entityIdFactory, contractId));
        }
        return null;
    }

    private Bytes bytecodeFrom(@NonNull QueryContext context, @NonNull Account contract) {
        AccountID accountId = contract.accountIdOrThrow();
        Long contractNumber = accountId.accountNumOrThrow();
        ContractID contractId = this.entityIdFactory.newContractId(contractNumber.longValue());
        Bytecode bytecode = ((ContractStateStore)context.createStore(ContractStateStore.class)).getBytecode(contractId);
        return bytecode == null ? null : bytecode.code();
    }
}

