/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import org.apache.tuweni.units.bigints.UInt256;

public record StorageAccess(@NonNull UInt256 key, @NonNull UInt256 value, @Nullable UInt256 writtenValue) {
    public StorageAccess {
        Objects.requireNonNull(key, "Key cannot be null");
        Objects.requireNonNull(value, "Current value cannot be null");
    }

    public Bytes trimmedKeyBytes() {
        return ConversionUtils.tuweniToPbjBytes(this.key.toBytes().trimLeadingZeros());
    }

    public Bytes trimmedValueBytes() {
        return ConversionUtils.tuweniToPbjBytes(this.value.toBytes().trimLeadingZeros());
    }

    public static StorageAccess newRead(@NonNull UInt256 key, @NonNull UInt256 value) {
        return new StorageAccess(key, value, null);
    }

    public static StorageAccess newWrite(@NonNull UInt256 key, @NonNull UInt256 oldValue, @NonNull UInt256 newValue) {
        return new StorageAccess(key, oldValue, Objects.requireNonNull(newValue));
    }

    public boolean isRemoval() {
        return this.writtenValue != null && this.writtenValue.isZero() && !this.value.isZero();
    }

    public boolean isLogicalChange() {
        return this.isUpdate() && !this.isZeroIntoEmptySlot();
    }

    public boolean isZeroIntoEmptySlot() {
        return this.writtenValue != null && this.writtenValue.isZero() && this.value.isZero();
    }

    public boolean isInsertion() {
        return this.writtenValue != null && !this.writtenValue.isZero() && this.value.isZero();
    }

    public boolean isReadOnly() {
        return this.writtenValue == null;
    }

    public boolean isUpdate() {
        return this.writtenValue != null;
    }

    public static enum StorageAccessType {
        UNKNOWN,
        READ_ONLY,
        REMOVAL,
        INSERTION,
        UPDATE,
        ZERO_INTO_EMPTY_SLOT;


        public static StorageAccessType getAccessType(@NonNull StorageAccess storageAccess) {
            Objects.requireNonNull(storageAccess);
            if (storageAccess.isReadOnly()) {
                return READ_ONLY;
            }
            if (storageAccess.isRemoval()) {
                return REMOVAL;
            }
            if (storageAccess.isInsertion()) {
                return INSERTION;
            }
            if (storageAccess.isZeroIntoEmptySlot()) {
                return ZERO_INTO_EMPTY_SLOT;
            }
            if (storageAccess.isUpdate()) {
                return UPDATE;
            }
            return UNKNOWN;
        }
    }
}

