/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.utils;

import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.hapi.block.stream.trace.ContractSlotUsage;
import com.hedera.hapi.block.stream.trace.EvmTransactionLog;
import com.hedera.hapi.block.stream.trace.SlotRead;
import com.hedera.hapi.block.stream.trace.WrittenSlotKeys;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.contract.ContractCreateTransactionBody;
import com.hedera.hapi.node.contract.ContractLoginfo;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.streams.ContractStateChange;
import com.hedera.hapi.streams.ContractStateChanges;
import com.hedera.hapi.streams.StorageChange;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaNativeOperations;
import com.hedera.node.app.service.contract.impl.exec.scope.HederaOperations;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.ReturnTypes;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.infra.StorageAccessTracker;
import com.hedera.node.app.service.contract.impl.records.ContractCallStreamBuilder;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.RootProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.contract.impl.state.StorageAccesses;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.contract.impl.utils.SynthTxnUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.HederaConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hiero.base.utility.CommonUtils;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.log.LogTopic;
import org.hyperledger.besu.evm.log.LogsBloomFilter;

public class ConversionUtils {
    public static final long EVM_ADDRESS_LENGTH_AS_LONG = 20L;
    public static final int EVM_ADDRESS_LENGTH_AS_INT = 20;
    public static final int NUM_LONG_ZEROS = 12;
    public static final long FEE_SCHEDULE_UNITS_PER_TINYCENT = 1000L;
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);

    private ConversionUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static TokenID[] asTokenIds(@NonNull EntityIdFactory entityIdFactory, com.esaulpaugh.headlong.abi.Address ... tokenAddresses) {
        Objects.requireNonNull(tokenAddresses);
        TokenID[] tokens = new TokenID[tokenAddresses.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = ConversionUtils.asTokenId(entityIdFactory, tokenAddresses[i]);
        }
        return tokens;
    }

    public static ContractID asNumericContractId(@NonNull EntityIdFactory entityIdFactory, @NonNull AccountID accountId) {
        return entityIdFactory.newContractId(accountId.accountNumOrThrow().longValue());
    }

    public static TokenID asTokenId(@NonNull EntityIdFactory entityIdFactory, @NonNull com.esaulpaugh.headlong.abi.Address address) {
        byte[] explicit = ConversionUtils.explicitFromHeadlong(address);
        long tokenNum = ConversionUtils.numberOfLongZero(explicit);
        return tokenNum == 0L ? TokenID.DEFAULT : entityIdFactory.newTokenId(tokenNum);
    }

    public static long asExactLongValueOrZero(@NonNull BigInteger value) {
        Objects.requireNonNull(value);
        if (value.compareTo(MIN_LONG_VALUE) < 0 || value.compareTo(MAX_LONG_VALUE) > 0) {
            return 0L;
        }
        return value.longValueExact();
    }

    public static com.esaulpaugh.headlong.abi.Address headlongAddressOf(@NonNull AccountID accountID) {
        Objects.requireNonNull(accountID);
        byte[] integralAddress = accountID.hasAccountNum() ? ConversionUtils.asEvmAddress(accountID.accountNumOrThrow()) : accountID.aliasOrElse(com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY).toByteArray();
        return ConversionUtils.asHeadlongAddress(integralAddress);
    }

    public static com.esaulpaugh.headlong.abi.Address headlongAddressOf(@NonNull ContractID contractId) {
        Objects.requireNonNull(contractId);
        byte[] integralAddress = contractId.hasContractNum() ? ConversionUtils.asEvmAddress(contractId.contractNumOrThrow()) : contractId.evmAddressOrThrow().toByteArray();
        return ConversionUtils.asHeadlongAddress(integralAddress);
    }

    public static com.esaulpaugh.headlong.abi.Address headlongAddressOf(@NonNull ScheduleID scheduleID) {
        Objects.requireNonNull(scheduleID);
        byte[] integralAddress = ConversionUtils.asEvmAddress(scheduleID.scheduleNum());
        return ConversionUtils.asHeadlongAddress(integralAddress);
    }

    public static com.esaulpaugh.headlong.abi.Address headlongAddressOf(@NonNull com.hederahashgraph.api.proto.java.ScheduleID scheduleID) {
        Objects.requireNonNull(scheduleID);
        byte[] integralAddress = ConversionUtils.asEvmAddress(scheduleID.getScheduleNum());
        return ConversionUtils.asHeadlongAddress(integralAddress);
    }

    public static com.esaulpaugh.headlong.abi.Address headlongAddressOf(@NonNull TokenID tokenId) {
        Objects.requireNonNull(tokenId);
        return ConversionUtils.asHeadlongAddress(ConversionUtils.asEvmAddress(tokenId.tokenNum()));
    }

    public static Address priorityAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        return Address.wrap((Bytes)Bytes.wrap((byte[])ConversionUtils.explicitAddressOf(account)));
    }

    public static ContractID asPriorityId(@NonNull ContractID contractID, @NonNull ReadableAccountStore accountStore) {
        Account maybeContract = accountStore.getContractById(contractID);
        if (maybeContract != null && maybeContract.alias().length() == 20L) {
            return ContractID.newBuilder().shardNum(contractID.shardNum()).realmNum(contractID.realmNum()).evmAddress(maybeContract.alias()).build();
        }
        return contractID;
    }

    public static com.esaulpaugh.headlong.abi.Address headlongAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        return ConversionUtils.asHeadlongAddress(ConversionUtils.explicitAddressOf(account));
    }

    public static com.esaulpaugh.headlong.abi.Address asHeadlongAddress(@NonNull byte[] explicit) {
        Objects.requireNonNull(explicit);
        BigInteger integralAddress = Bytes.wrap((byte[])explicit).toUnsignedBigInteger();
        return com.esaulpaugh.headlong.abi.Address.wrap((String)com.esaulpaugh.headlong.abi.Address.toChecksumAddress((BigInteger)integralAddress));
    }

    public static List<ContractLoginfo> pbjLogsFrom(@NonNull EntityIdFactory entityIdFactory, @NonNull List<Log> logs) {
        ArrayList<ContractLoginfo> pbjLogs = new ArrayList<ContractLoginfo>();
        for (Log log : logs) {
            pbjLogs.add(ConversionUtils.pbjLogFrom(entityIdFactory, log));
        }
        return pbjLogs;
    }

    public static Hash ethHashFrom(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes sha384Hash) {
        Objects.requireNonNull(sha384Hash);
        byte[] prefixBytes = new byte[32];
        sha384Hash.getBytes(0L, prefixBytes, 0, prefixBytes.length);
        return Hash.wrap((Bytes32)Bytes32.wrap((byte[])prefixBytes));
    }

    @Nullable
    public static ContractStateChanges asPbjStateChanges(@Nullable List<StorageAccesses> storageAccesses) {
        if (storageAccesses == null) {
            return null;
        }
        ArrayList<ContractStateChange> allStateChanges = new ArrayList<ContractStateChange>();
        for (StorageAccesses storageAccess : storageAccesses) {
            ArrayList<StorageChange> changes = new ArrayList<StorageChange>();
            for (StorageAccess access : storageAccess.accesses()) {
                changes.add(new StorageChange(ConversionUtils.tuweniToPbjBytes(access.key().trimLeadingZeros()), ConversionUtils.tuweniToPbjBytes(access.value().trimLeadingZeros()), access.isReadOnly() ? null : ConversionUtils.tuweniToPbjBytes(Objects.requireNonNull(access.writtenValue()).trimLeadingZeros())));
            }
            allStateChanges.add(new ContractStateChange(storageAccess.contractID(), changes));
        }
        return new ContractStateChanges(allStateChanges);
    }

    @Nullable
    public static List<ContractSlotUsage> asPbjSlotUsages(@Nullable List<StorageAccesses> storageAccesses, boolean traceExplicitWrites) {
        if (storageAccesses == null) {
            return null;
        }
        ArrayList<ContractSlotUsage> slotUsages = new ArrayList<ContractSlotUsage>();
        for (StorageAccesses storageAccess : storageAccesses) {
            ArrayList<SlotRead> reads = new ArrayList<SlotRead>();
            ArrayList<com.hedera.pbj.runtime.io.buffer.Bytes> writes = traceExplicitWrites ? new ArrayList<com.hedera.pbj.runtime.io.buffer.Bytes>() : null;
            for (StorageAccess access : storageAccess.accesses()) {
                if (!access.isReadOnly()) {
                    if (writes != null) {
                        writes.add(access.trimmedKeyBytes());
                        reads.add(SlotRead.newBuilder().index(writes.size() - 1).readValue(access.trimmedValueBytes()).build());
                        continue;
                    }
                    reads.add(SlotRead.newBuilder().key(ConversionUtils.tuweniToPbjBytes((Bytes)access.key())).readValue(access.trimmedValueBytes()).build());
                    continue;
                }
                reads.add(SlotRead.newBuilder().key(access.trimmedKeyBytes()).readValue(access.trimmedValueBytes()).build());
            }
            if (traceExplicitWrites) {
                slotUsages.add(ContractSlotUsage.newBuilder().contractId(storageAccess.contractID()).writtenSlotKeys(new WrittenSlotKeys(writes)).slotReads(reads).build());
                continue;
            }
            slotUsages.add(new ContractSlotUsage(storageAccess.contractID(), null, reads));
        }
        return slotUsages;
    }

    public static ContractLoginfo pbjLogFrom(@NonNull EntityIdFactory entityIdFactory, @NonNull Log log) {
        long loggerNumber = ConversionUtils.numberOfLongZero(log.getLogger());
        ArrayList<com.hedera.pbj.runtime.io.buffer.Bytes> loggedTopics = new ArrayList<com.hedera.pbj.runtime.io.buffer.Bytes>();
        for (LogTopic topic : log.getTopics()) {
            loggedTopics.add(ConversionUtils.tuweniToPbjBytes((Bytes)topic));
        }
        return ContractLoginfo.newBuilder().contractID(entityIdFactory.newContractId(loggerNumber)).data(ConversionUtils.tuweniToPbjBytes(log.getData())).topic(loggedTopics).bloom(ConversionUtils.bloomFor(log)).build();
    }

    public static List<EvmTransactionLog> asHederaLogs(@NonNull List<Log> logs, @NonNull EntityIdFactory entityIdFactory) {
        Objects.requireNonNull(logs);
        ArrayList<EvmTransactionLog> hederaLogs = new ArrayList<EvmTransactionLog>(logs.size());
        for (Log log : logs) {
            hederaLogs.add(ConversionUtils.asHederaLog(entityIdFactory, log));
        }
        return hederaLogs;
    }

    public static EvmTransactionLog asHederaLog(@NonNull EntityIdFactory entityIdFactory, @NonNull Log log) {
        ArrayList<com.hedera.pbj.runtime.io.buffer.Bytes> topics = new ArrayList<com.hedera.pbj.runtime.io.buffer.Bytes>(log.getTopics().size());
        for (LogTopic topic : log.getTopics()) {
            topics.add(ConversionUtils.tuweniToPbjBytes(topic.trimLeadingZeros()));
        }
        return new EvmTransactionLog(entityIdFactory.newContractId(ConversionUtils.numberOfLongZero(log.getLogger())), ConversionUtils.tuweniToPbjBytes(log.getData()), topics);
    }

    public static long hederaIdNumOfContractIn(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        return ConversionUtils.hederaIdNumberIn(frame, frame.getContractAddress());
    }

    public static long hederaIdNumOfOriginatorIn(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        return ConversionUtils.hederaIdNumberIn(frame, frame.getOriginatorAddress());
    }

    private static long hederaIdNumberIn(@NonNull MessageFrame frame, @NonNull Address address) {
        return ConversionUtils.isLongZero(address) ? ConversionUtils.numberOfLongZero(address) : FrameUtils.proxyUpdaterFor(frame).getHederaContractId(address).contractNumOrThrow();
    }

    public static Address longZeroAddressOfRecipient(@NonNull MessageFrame frame) {
        return ConversionUtils.longZeroAddressIn(frame, frame.getRecipientAddress());
    }

    public static long accountNumberForEvmReference(@NonNull com.esaulpaugh.headlong.abi.Address address, @NonNull HederaNativeOperations nativeOperations) {
        byte[] explicit = ConversionUtils.explicitFromHeadlong(address);
        long number = ConversionUtils.maybeMissingNumberOf(explicit, nativeOperations);
        if (number == -1L) {
            return -1L;
        }
        Account account = nativeOperations.getAccount(nativeOperations.entityIdFactory().newAccountId(number));
        if (account == null || account.deleted()) {
            return -1L;
        }
        if (!Arrays.equals(explicit, ConversionUtils.explicitAddressOf(account))) {
            return -2L;
        }
        return number;
    }

    public static long maybeMissingNumberOf(@NonNull Address address, @NonNull HederaNativeOperations nativeOperations) {
        return ConversionUtils.maybeMissingNumberOf(address.toArrayUnsafe(), nativeOperations);
    }

    public static long numberOfLongZero(@NonNull Address address) {
        return ConversionUtils.numberOfLongZero(address.toArray());
    }

    public static boolean isLongZero(@NonNull Address address) {
        return ConversionUtils.isLongZeroAddress(address.toArrayUnsafe());
    }

    public static boolean isLongZero(@NonNull com.esaulpaugh.headlong.abi.Address address) {
        return ConversionUtils.isLongZeroAddress(ConversionUtils.explicitFromHeadlong(address));
    }

    public static boolean isLongZeroAddress(byte[] explicit) {
        for (int i = 0; i < 12; ++i) {
            if (explicit[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes aliasFrom(@NonNull Address address) {
        return com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])address.toArrayUnsafe());
    }

    public static Address asLongZeroAddress(long number) {
        return Address.wrap((Bytes)Bytes.wrap((byte[])ConversionUtils.asEvmAddress(number)));
    }

    public static Address asLongZeroAddress(@NonNull AccountID accountID) {
        return Address.wrap((Bytes)Bytes.wrap((byte[])ConversionUtils.asEvmAddress(accountID.accountNumOrThrow())));
    }

    @NonNull
    public static com.hedera.pbj.runtime.io.buffer.Bytes tuweniToPbjBytes(@NonNull Bytes bytes) {
        return com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])Objects.requireNonNull(bytes).toArrayUnsafe());
    }

    public static ContractID asEvmContractId(@NonNull EntityIdFactory entityIdFactory, @NonNull Address address) {
        return entityIdFactory.newContractIdWithEvmAddress(ConversionUtils.tuweniToPbjBytes((Bytes)address));
    }

    public static ContractID asNumberedContractId(@NonNull EntityIdFactory entityIdFactory, @NonNull Address address) {
        if (!ConversionUtils.isLongZero(address)) {
            throw new IllegalArgumentException("Cannot extract id number from address " + String.valueOf(address));
        }
        return entityIdFactory.newContractId(ConversionUtils.numberOfLongZero(address));
    }

    public static ContractID asContractId(@NonNull EntityIdFactory entityIdFactory, @NonNull Address address) {
        if (ConversionUtils.isLongZero(address)) {
            return entityIdFactory.newContractId(ConversionUtils.numberOfLongZero(address));
        }
        return ConversionUtils.asEvmContractId(entityIdFactory, address);
    }

    public static ScheduleID addressToScheduleID(@NonNull EntityIdFactory entityIdFactory, @NonNull com.esaulpaugh.headlong.abi.Address address) {
        if (!ConversionUtils.isLongZero(address)) {
            throw new IllegalArgumentException("Cannot extract id number from address " + String.valueOf(address));
        }
        String addressHex = com.esaulpaugh.headlong.abi.Address.toChecksumAddress((BigInteger)address.value());
        String scheduleNum = addressHex.substring(26, 42);
        return entityIdFactory.newScheduleId(new BigInteger(scheduleNum, 16).longValue());
    }

    public static void throwIfUnsuccessfulCall(@NonNull CallOutcome outcome, @NonNull HederaOperations hederaOperations, @NonNull ContractCallStreamBuilder streamBuilder) {
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(hederaOperations);
        Objects.requireNonNull(streamBuilder);
        if (outcome.status() != ResponseCodeEnum.SUCCESS) {
            throw new HandleException(outcome.status(), feeChargingContext -> {
                hederaOperations.replayGasChargingIn((FeeCharging.Context)feeChargingContext);
                outcome.addCalledContractIfNotAborted(streamBuilder);
            });
        }
    }

    public static void throwIfUnsuccessfulCreate(@NonNull CallOutcome outcome, @NonNull HederaOperations hederaOperations) {
        Objects.requireNonNull(outcome);
        Objects.requireNonNull(hederaOperations);
        if (outcome.status() != ResponseCodeEnum.SUCCESS) {
            throw new HandleException(outcome.status(), hederaOperations::replayGasChargingIn);
        }
    }

    @NonNull
    public static Bytes pbjToTuweniBytes(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes bytes) {
        if (bytes.length() == 0L) {
            return Bytes.EMPTY;
        }
        return Bytes.wrap((byte[])ConversionUtils.clampedBytes(bytes, 0, Integer.MAX_VALUE));
    }

    public static boolean isEvmAddress(@Nullable com.hedera.pbj.runtime.io.buffer.Bytes alias) {
        return alias != null && alias.length() == 20L;
    }

    @NonNull
    public static Address pbjToBesuAddress(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes bytes) {
        return Address.wrap((Bytes)Bytes.wrap((byte[])ConversionUtils.clampedBytes(bytes, 20, 20)));
    }

    @NonNull
    public static Hash pbjToBesuHash(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes bytes) {
        return Hash.wrap((Bytes32)Bytes32.wrap((byte[])ConversionUtils.clampedBytes(bytes, 32, 32)));
    }

    @NonNull
    public static UInt256 pbjToTuweniUInt256(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes bytes) {
        return bytes.length() == 0L ? UInt256.ZERO : UInt256.fromBytes((Bytes)Bytes32.wrap((byte[])ConversionUtils.clampedBytes(bytes, 0, 32)));
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes bloomForAll(@NonNull List<Log> logs) {
        return com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])LogsBloomFilter.builder().insertLogs(logs).build().toArray());
    }

    private static byte[] clampedBytes(@NonNull com.hedera.pbj.runtime.io.buffer.Bytes bytes, int minLength, int maxLength) {
        int length = Math.toIntExact(Objects.requireNonNull(bytes).length());
        if (length < minLength) {
            throw new IllegalArgumentException("Expected at least " + minLength + " bytes, got " + String.valueOf(bytes));
        }
        if (length > maxLength) {
            throw new IllegalArgumentException("Expected at most " + maxLength + " bytes, got " + String.valueOf(bytes));
        }
        byte[] data = new byte[length];
        bytes.getBytes(0L, data);
        return data;
    }

    public static byte[] asEvmAddress(long num) {
        return ConversionUtils.copyToLeftPaddedByteArray(num, new byte[20]);
    }

    public static byte[] copyToLeftPaddedByteArray(long value, byte[] dest) {
        int i = 7;
        int j = dest.length - 1;
        while (i >= 0) {
            dest[j] = (byte)(value & 0xFFL);
            value >>= 8;
            --i;
            --j;
        }
        return dest;
    }

    public static byte[] explicitFromHeadlong(@NonNull com.esaulpaugh.headlong.abi.Address address) {
        return CommonUtils.unhex((String)address.toString().substring(2));
    }

    public static long numberOfLongZero(@NonNull byte[] explicit) {
        return ConversionUtils.longFrom(explicit[12], explicit[13], explicit[14], explicit[15], explicit[16], explicit[17], explicit[18], explicit[19]);
    }

    private static long longFrom(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        return ((long)b1 & 0xFFL) << 56 | ((long)b2 & 0xFFL) << 48 | ((long)b3 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b5 & 0xFFL) << 24 | ((long)b6 & 0xFFL) << 16 | ((long)b7 & 0xFFL) << 8 | (long)b8 & 0xFFL;
    }

    public static com.hedera.pbj.runtime.io.buffer.Bytes bloomFor(@NonNull Log log) {
        Objects.requireNonNull(log);
        return com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])LogsBloomFilter.builder().insertLog(log).build().toArray());
    }

    private static Address longZeroAddressIn(@NonNull MessageFrame frame, @NonNull Address address) {
        return ConversionUtils.isLongZero(address) ? address : ConversionUtils.asLongZeroAddress(FrameUtils.proxyUpdaterFor(frame).getHederaContractId(address).contractNumOrThrow());
    }

    private static long maybeMissingNumberOf(@NonNull byte[] explicit, @NonNull HederaNativeOperations nativeOperations) {
        if (ConversionUtils.isLongZeroAddress(explicit)) {
            return ConversionUtils.longFrom(explicit[12], explicit[13], explicit[14], explicit[15], explicit[16], explicit[17], explicit[18], explicit[19]);
        }
        com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])explicit));
        HederaConfig config = (HederaConfig)nativeOperations.configuration().getConfigData(HederaConfig.class);
        return evmAddress == null ? -1L : nativeOperations.resolveAlias(config.shard(), config.realm(), evmAddress);
    }

    public static byte[] explicitAddressOf(@NonNull Account account) {
        Objects.requireNonNull(account);
        com.hedera.pbj.runtime.io.buffer.Bytes evmAddress = AliasUtils.extractEvmAddress((com.hedera.pbj.runtime.io.buffer.Bytes)account.alias());
        return evmAddress != null ? evmAddress.toByteArray() : ConversionUtils.asEvmAddress(account.accountIdOrThrow().accountNumOrThrow());
    }

    public static Address fromHeadlongAddress(@NonNull com.esaulpaugh.headlong.abi.Address address) {
        Objects.requireNonNull(address);
        return Address.fromHexString((String)address.toString());
    }

    public static long fromTinycentsToTinybars(ExchangeRate exchangeRate, long tinycents) {
        return ConversionUtils.fromAToB(BigInteger.valueOf(tinycents), exchangeRate.hbarEquiv(), exchangeRate.centEquiv()).longValueExact();
    }

    public static long fromTinybarsToTinycents(ExchangeRate exchangeRate, long tinyBars) {
        return ConversionUtils.fromAToB(BigInteger.valueOf(tinyBars), exchangeRate.centEquiv(), exchangeRate.hbarEquiv()).longValueExact();
    }

    @NonNull
    public static BigInteger fromAToB(@NonNull BigInteger aAmount, int bEquiv, int aEquiv) {
        return aAmount.multiply(BigInteger.valueOf(bEquiv)).divide(BigInteger.valueOf(aEquiv));
    }

    @NonNull
    public static Address contractIDToBesuAddress(@NonNull EntityIdFactory entityIdFactory, @NonNull ContractID contractId) {
        if (contractId.hasEvmAddress()) {
            return ConversionUtils.pbjToBesuAddress(contractId.evmAddressOrThrow());
        }
        return ConversionUtils.asLongZeroAddress(entityIdFactory.newAccountId(contractId.contractNumOrElse(Long.valueOf(0L)).longValue()));
    }

    @NonNull
    public static Long contractIDToNum(ContractID contractId) {
        byte[] evmAddress;
        Long id = contractId.hasEvmAddress() ? (ConversionUtils.isLongZeroAddress(evmAddress = contractId.evmAddressOrThrow().toByteArray()) ? Long.valueOf(ConversionUtils.numberOfLongZero(evmAddress)) : Long.valueOf(0L)) : contractId.contractNumOrElse(Long.valueOf(0L));
        return id;
    }

    @NonNull
    public static ContractCreateTransactionBody sponsorCustomizedCreation(@NonNull ContractCreateTransactionBody op, @NonNull Account sponsor) {
        Objects.requireNonNull(op);
        Objects.requireNonNull(sponsor);
        ContractCreateTransactionBody.Builder builder = op.copyBuilder();
        if (sponsor.memo() != null) {
            builder.memo(sponsor.memo());
        }
        if (SynthTxnUtils.hasNonDegenerateAutoRenewAccountId(sponsor)) {
            builder.autoRenewAccountId(sponsor.autoRenewAccountId());
        }
        if (sponsor.stakedAccountId() != null) {
            builder.stakedAccountId(sponsor.stakedAccountId());
        }
        if (sponsor.autoRenewSeconds() > 0L) {
            builder.autoRenewPeriod(Duration.newBuilder().seconds(sponsor.autoRenewSeconds()).build());
        }
        return builder.maxAutomaticTokenAssociations(sponsor.maxAutoAssociations()).declineReward(sponsor.declineReward()).build();
    }

    @NonNull
    public static ContractCreateTransactionBody selfManagedCustomizedCreation(@NonNull ContractCreateTransactionBody op, @NonNull ContractID contractID) {
        Objects.requireNonNull(op);
        ContractCreateTransactionBody.Builder builder = op.copyBuilder();
        return builder.adminKey(Key.newBuilder().contractID(contractID.copyBuilder().build()).build()).build();
    }

    @NonNull
    public static Tuple keyTupleFor(@NonNull Key key) {
        return Tuple.of((Object)false, (Object)ConversionUtils.headlongAddressOf(key.contractIDOrElse(ReturnTypes.ZERO_CONTRACT_ID)), (Object)key.ed25519OrElse(com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY).toByteArray(), (Object)key.ecdsaSecp256k1OrElse(com.hedera.pbj.runtime.io.buffer.Bytes.EMPTY).toByteArray(), (Object)ConversionUtils.headlongAddressOf(key.delegatableContractIdOrElse(ReturnTypes.ZERO_CONTRACT_ID)));
    }

    public static byte[] removeIfAnyLeading0x(com.hedera.pbj.runtime.io.buffer.Bytes contents) {
        byte[] hexPrefix = new byte[]{48, 120};
        long offset = contents.matchesPrefix(hexPrefix) ? (long)hexPrefix.length : 0L;
        long len = contents.length() - offset;
        return contents.getBytes(offset, len).toByteArray();
    }

    public static Log asBesuLog(@NonNull EvmTransactionLog log, @NonNull List<com.hedera.pbj.runtime.io.buffer.Bytes> paddedTopics) {
        Objects.requireNonNull(log);
        Objects.requireNonNull(paddedTopics);
        return new Log(ConversionUtils.asLongZeroAddress(log.contractIdOrThrow().contractNumOrThrow()), ConversionUtils.pbjToTuweniBytes(log.data()), paddedTopics.stream().map(ConversionUtils::pbjToTuweniBytes).map(LogTopic::create).toList());
    }

    @Nullable
    public static TxStorageUsage txStorageUsageFrom(@Nullable ProxyWorldUpdater updater, @Nullable StorageAccessTracker accessTracker, boolean checkForWrites) {
        if (accessTracker == null) {
            return null;
        }
        if (checkForWrites) {
            Objects.requireNonNull(updater);
            if (updater instanceof RootProxyWorldUpdater) {
                RootProxyWorldUpdater rootProxyWorldUpdater = (RootProxyWorldUpdater)updater;
                TxStorageUsage txStorageUsage = rootProxyWorldUpdater.getTxStorageUsage();
                List<StorageAccesses> accesses = accessTracker.getReadsMergedWith(txStorageUsage.accesses());
                return new TxStorageUsage(accesses, txStorageUsage.changedKeys());
            }
            return new TxStorageUsage(accessTracker.getJustReads(), null);
        }
        return new TxStorageUsage(accessTracker.getJustReads(), null);
    }
}

