/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.stream.ReadableStreamingData;
import com.hedera.pbj.runtime.io.stream.WritableStreamingData;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateKeyUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskKeySerializer;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.disk.OnDiskValueSerializer;
import com.swirlds.state.merkle.disk.QueueState;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.merkle.singleton.StringLeaf;
import com.swirlds.state.merkle.singleton.ValueLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;

public final class StateUtils {
    public static final int STATE_VALUE_QUEUE_STATE = 8001;
    private static final Bytes[] VIRTUAL_MAP_KEY_CACHE = new Bytes[65536];

    private StateUtils() {
    }

    public static <T> int writeToStream(@NonNull OutputStream out, @NonNull Codec<T> codec, @Nullable T object) throws IOException {
        WritableStreamingData stream = new WritableStreamingData(out);
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        codec.write(object, (WritableSequentialData)new WritableStreamingData((OutputStream)byteStream));
        stream.writeInt(byteStream.size());
        stream.writeBytes(byteStream.toByteArray());
        return byteStream.size();
    }

    @Nullable
    public static <T> T readFromStream(@NonNull InputStream in, @NonNull Codec<T> codec) throws IOException {
        ReadableStreamingData stream = new ReadableStreamingData(in);
        int size = stream.readInt();
        stream.limit((long)size + 4L);
        try {
            return (T)codec.parse((ReadableSequentialData)stream);
        }
        catch (ParseException ex) {
            throw new IOException(ex);
        }
    }

    @Deprecated
    public static void registerWithSystem(@NonNull StateMetadata md, @NonNull ConstructableRegistry constructableRegistry) {
        try {
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskKey.class, () -> new OnDiskKey(md.onDiskKeyClassId(), md.stateDefinition().keyCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskKeySerializer.class, () -> new OnDiskKeySerializer(md.onDiskKeySerializerClassId(), md.onDiskKeyClassId(), md.stateDefinition().keyCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskValue.class, () -> new OnDiskValue(md.onDiskValueClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(OnDiskValueSerializer.class, () -> new OnDiskValueSerializer(md.onDiskValueSerializerClassId(), md.onDiskValueClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(SingletonNode.class, () -> new SingletonNode<Object>(StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), md.singletonClassId(), md.stateDefinition().valueCodec(), null)));
            constructableRegistry.registerConstructable(new ClassConstructorPair(QueueNode.class, () -> new QueueNode(StateMetadata.computeLabel((String)md.serviceName(), (String)md.stateDefinition().stateKey()), md.queueNodeClassId(), md.singletonClassId(), md.stateDefinition().valueCodec())));
            constructableRegistry.registerConstructable(new ClassConstructorPair(StringLeaf.class, StringLeaf::new));
            constructableRegistry.registerConstructable(new ClassConstructorPair(ValueLeaf.class, () -> new ValueLeaf(md.singletonClassId(), md.stateDefinition().valueCodec())));
        }
        catch (ConstructableRegistryException e) {
            throw new IllegalStateException("Failed to register with the system '" + md.serviceName() + ":" + md.stateDefinition().stateKey() + "'", e);
        }
    }

    public static Bytes getStateKeyForSingleton(int stateId) {
        Bytes key = VIRTUAL_MAP_KEY_CACHE[stateId];
        if (key == null) {
            StateUtils.VIRTUAL_MAP_KEY_CACHE[stateId] = key = StateKeyUtils.singletonKey(stateId);
        }
        return key;
    }

    public static Bytes getStateKeyForQueue(int stateId, long index) {
        return StateKeyUtils.queueKey(stateId, index);
    }

    public static <K> Bytes getStateKeyForKv(int stateId, K key, Codec<K> keyCodec) {
        return StateKeyUtils.kvKey(stateId, key, keyCodec);
    }

    public static <V> StateValue<V> getStateValueForSingleton(int stateId, V value) {
        return new StateValue<V>(stateId, value);
    }

    public static <V> StateValue<V> getStateValueForQueue(int stateId, V value) {
        return new StateValue<V>(stateId, value);
    }

    public static StateValue<QueueState> getStateValueForQueueState(QueueState queueState) {
        return new StateValue<QueueState>(8001, queueState);
    }

    public static <V> StateValue<V> getStateValueForKv(int stateId, V value) {
        return new StateValue<V>(stateId, value);
    }
}

