/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network;

import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.network.ExternalIpAddress;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Network {
    private static final Logger logger = LogManager.getLogger(Network.class);
    private static final String LOCALHOST = "127.0.0.1";
    private static Collection<InetAddress> ownAddresses;
    private static String ownAddress;
    private static ExternalIpAddress externalAddress;

    private Network() {
    }

    public static boolean isOwn(InetAddress addr) {
        return Network.getOwnAddresses().contains(addr) || addr.isLoopbackAddress();
    }

    @NonNull
    public static ExternalIpAddress getExternalIpAddress() {
        if (externalAddress == null) {
            String ip = Network.getOwnAddresses().stream().filter(Objects::nonNull).filter(address -> !Network.isPrivateIP(address)).map(InetAddress::getHostAddress).findFirst().orElse(null);
            externalAddress = ip == null ? ExternalIpAddress.NO_IP : new ExternalIpAddress(ip);
        }
        return externalAddress;
    }

    @Nullable
    public static String getInternalIPAddress() {
        if (ownAddress == null) {
            ownAddress = Network.getOwnAddresses().stream().filter(a -> !LOCALHOST.equals(a.getHostAddress())).max(Comparator.comparing(Inet4Address.class::isInstance)).map(InetAddress::getHostAddress).orElse(null);
        }
        return ownAddress;
    }

    public static Collection<InetAddress> getOwnAddresses() {
        if (ownAddresses == null) {
            ownAddresses = Network.computeOwnAddresses();
        }
        return ownAddresses;
    }

    private static Collection<InetAddress> computeOwnAddresses() {
        HashSet<InetAddress> result = new HashSet<InetAddress>();
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                Enumeration<InetAddress> addresses = interfaces.nextElement().getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    result.add(addr);
                }
            }
            return result;
        }
        catch (SocketException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error getting own addresses", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public static boolean isPrivateIP(@NonNull InetAddress addr) {
        Objects.requireNonNull(addr);
        byte[] ip = addr.getAddress();
        if (addr instanceof Inet4Address) {
            int firstBlock = ip[0] & 0xFF;
            int secondBlock = ip[1] & 0xFF;
            return firstBlock == 10 || firstBlock == 172 && secondBlock >= 16 && secondBlock <= 31 || firstBlock == 192 && secondBlock == 168 || firstBlock == 127;
        }
        if (addr instanceof Inet6Address) {
            return (ip[0] & 0xFF) == 254 && (ip[1] & 0xC0) == 128 || (ip[0] & 0xFF) == 253 || (ip[0] & 0xFF) == 0 && (ip[1] & 0xC0) == 0;
        }
        return false;
    }

    static {
        ownAddress = null;
        externalAddress = null;
    }
}

