/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.proof;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.merkle.MerkleLeaf;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.utility.Threshold;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.proof.SignatureVerifier;
import com.swirlds.platform.proof.algorithms.NodeSignature;
import com.swirlds.platform.proof.algorithms.StateProofSerialization;
import com.swirlds.platform.proof.algorithms.StateProofTreeBuilder;
import com.swirlds.platform.proof.algorithms.StateProofUtils;
import com.swirlds.platform.proof.tree.StateProofNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Signature;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;

public class StateProof
implements SelfSerializable {
    private static final long CLASS_ID = -4657489490582556124L;
    private List<NodeSignature> signatures;
    private StateProofNode root;
    private List<MerkleLeaf> payloads;
    private byte[] hashBytes;

    public StateProof() {
    }

    public StateProof(@NonNull Cryptography cryptography, @NonNull MerkleNode merkleRoot, @NonNull Map<NodeId, Signature> signatures, @NonNull List<MerkleLeaf> payloads) {
        Objects.requireNonNull(cryptography);
        Objects.requireNonNull(merkleRoot);
        Objects.requireNonNull(signatures);
        Objects.requireNonNull(payloads);
        this.payloads = StateProofTreeBuilder.validatePayloads(payloads);
        this.signatures = StateProofTreeBuilder.processSignatures(signatures);
        this.root = StateProofTreeBuilder.buildStateProofTree(cryptography, merkleRoot, payloads);
    }

    public boolean isValid(@NonNull Cryptography cryptography, @NonNull AddressBook addressBook, @NonNull Threshold threshold) {
        return this.isValid(addressBook, threshold, (Signature signature, byte[] bytes, PublicKey publicKey) -> CryptoStatic.verifySignature(Bytes.wrap((byte[])bytes), signature.getBytes(), publicKey));
    }

    public boolean isValid(@NonNull AddressBook addressBook, @NonNull Threshold threshold, @NonNull SignatureVerifier signatureVerifier) {
        Objects.requireNonNull(addressBook);
        Objects.requireNonNull(threshold);
        Objects.requireNonNull(signatureVerifier);
        if (this.hashBytes == null) {
            this.hashBytes = StateProofUtils.computeStateProofTreeHash(this.root);
        }
        long validWeight = StateProofUtils.computeValidSignatureWeight(addressBook, this.signatures, signatureVerifier, this.hashBytes);
        return threshold.isSatisfiedBy(validWeight, addressBook.getTotalWeight());
    }

    @NonNull
    public List<MerkleLeaf> getPayloads() {
        if (this.payloads == null) {
            throw new IllegalStateException("StateProof has not been fully deserialized");
        }
        return this.payloads;
    }

    public long getClassId() {
        return -4657489490582556124L;
    }

    public int getVersion() {
        return 1;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        StateProofSerialization.serializeSignatures(out, this.signatures);
        StateProofSerialization.serializeStateProofTree(out, this.root);
    }

    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        this.signatures = StateProofSerialization.deserializeSignatures(in);
        this.root = StateProofSerialization.deserializeStateProofTree(in);
        this.payloads = StateProofSerialization.extractPayloads(this.root);
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

