/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenFeeScheduleUpdateTransactionBody;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.token.TokenOpsUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.impl.validators.CustomFeesValidator;
import com.hedera.node.app.service.token.records.TokenBaseStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TokensConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenFeeScheduleUpdateHandler
implements TransactionHandler {
    private final CustomFeesValidator customFeesValidator;

    @Inject
    public TokenFeeScheduleUpdateHandler(@NonNull CustomFeesValidator customFeesValidator) {
        Objects.requireNonNull(customFeesValidator);
        this.customFeesValidator = customFeesValidator;
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        Objects.requireNonNull(txn);
        TokenFeeScheduleUpdateTransactionBody op = txn.tokenFeeScheduleUpdateOrThrow();
        if (!op.hasTokenId()) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenFeeScheduleUpdateTransactionBody op = context.body().tokenFeeScheduleUpdateOrThrow();
        TokenID tokenId = op.tokenIdOrElse(TokenID.DEFAULT);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMetadata = tokenStore.getTokenMeta(tokenId);
        if (tokenMetadata == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (tokenMetadata.hasFeeScheduleKey()) {
            context.requireKey(tokenMetadata.feeScheduleKey());
            for (CustomFee customFee : op.customFees()) {
                AccountID collector = customFee.feeCollectorAccountIdOrElse(AccountID.DEFAULT);
                context.requireKeyIfReceiverSigRequired(collector, ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
            }
        }
    }

    public void handle(@NonNull HandleContext context) {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokensConfig config = (TokensConfig)context.configuration().getConfigData(TokensConfig.class);
        TokenFeeScheduleUpdateTransactionBody op = txn.tokenFeeScheduleUpdateOrThrow();
        StoreFactory storeFactory = context.storeFactory();
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        Token token = this.validateSemantics(op, tokenStore, config);
        ReadableAccountStore readableAccountStore = (ReadableAccountStore)storeFactory.readableStore(ReadableAccountStore.class);
        ReadableTokenRelationStore readableTokenRelsStore = (ReadableTokenRelationStore)storeFactory.readableStore(ReadableTokenRelationStore.class);
        if (token.customFees().isEmpty() && op.customFees().isEmpty()) {
            throw new HandleException(ResponseCodeEnum.CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES);
        }
        this.customFeesValidator.validateForFeeScheduleUpdate(token, readableAccountStore, readableTokenRelsStore, tokenStore, op.customFees(), context.expiryValidator());
        Token.Builder copy = token.copyBuilder().customFees(op.customFees());
        tokenStore.put(copy.build());
        TokenBaseStreamBuilder tokenBaseStreamBuilder = (TokenBaseStreamBuilder)context.savepointStack().getBaseBuilder(TokenBaseStreamBuilder.class);
        tokenBaseStreamBuilder.tokenType(token.tokenType());
    }

    private Token validateSemantics(@NonNull TokenFeeScheduleUpdateTransactionBody op, @NonNull WritableTokenStore tokenStore, @NonNull TokensConfig config) {
        Token token = TokenHandlerHelper.getIfUsable(op.tokenIdOrElse(TokenID.DEFAULT), tokenStore);
        HandleException.validateTrue((boolean)token.hasFeeScheduleKey(), (ResponseCodeEnum)ResponseCodeEnum.TOKEN_HAS_NO_FEE_SCHEDULE_KEY);
        HandleException.validateTrue((op.customFees().size() <= config.maxCustomFeesAllowed() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
        return token;
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        TransactionBody body = feeContext.body();
        TokenFeeScheduleUpdateTransactionBody op = body.tokenFeeScheduleUpdateOrThrow();
        Token token = ((ReadableTokenStore)feeContext.readableStore(ReadableTokenStore.class)).get(op.tokenIdOrThrow());
        TokenOpsUsage tokenOpsUsage = new TokenOpsUsage();
        List<CustomFee> newFees = op.customFees();
        newFees = newFees.stream().map(fee -> {
            if (fee.hasFixedFee() && fee.fixedFee().denominatingTokenId() == null) {
                return fee.copyBuilder().fixedFee(fee.fixedFee().copyBuilder().denominatingTokenId(TokenID.DEFAULT).build()).build();
            }
            return fee;
        }).toList();
        int newReprBytes = tokenOpsUsage.bytesNeededToRepr(newFees.stream().map(CommonPbjConverters::fromPbj).toList());
        long effConsTime = body.transactionIDOrThrow().transactionValidStartOrThrow().seconds();
        long lifetime = Math.max(0L, token == null ? 0L : token.expirationSecond() - effConsTime);
        List customFees = token == null ? Collections.emptyList() : token.customFees();
        int existingFeeReprBytes = this.currentFeeScheduleSize(customFees, tokenOpsUsage);
        long rbsDelta = SingletonEstimatorUtils.ESTIMATOR_UTILS.changeInBsUsage((long)existingFeeReprBytes, lifetime, (long)newReprBytes, lifetime);
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).addBytesPerTransaction(24L + (long)newReprBytes).addRamByteSeconds(rbsDelta).calculate();
    }

    private int currentFeeScheduleSize(List<CustomFee> feeSchedule, TokenOpsUsage tokenOpsUsage) {
        int numFixedHbarFees = 0;
        int numFixedHtsFees = 0;
        int numFractionalFees = 0;
        int numRoyaltyNoFallbackFees = 0;
        int numRoyaltyHtsFallbackFees = 0;
        int numRoyaltyHbarFallbackFees = 0;
        for (CustomFee fee : feeSchedule) {
            if (((CustomFee.FeeOneOfType)fee.fee().kind()).equals((Object)CustomFee.FeeOneOfType.FIXED_FEE)) {
                if (fee.fixedFee().hasDenominatingTokenId()) {
                    ++numFixedHtsFees;
                    continue;
                }
                ++numFixedHbarFees;
                continue;
            }
            if (((CustomFee.FeeOneOfType)fee.fee().kind()).equals((Object)CustomFee.FeeOneOfType.FRACTIONAL_FEE)) {
                ++numFractionalFees;
                continue;
            }
            RoyaltyFee royaltyFee = fee.royaltyFee();
            FixedFee fallbackFee = royaltyFee.fallbackFee();
            if (fallbackFee != null) {
                if (fallbackFee.hasDenominatingTokenId()) {
                    ++numRoyaltyHtsFallbackFees;
                    continue;
                }
                ++numRoyaltyHbarFallbackFees;
                continue;
            }
            ++numRoyaltyNoFallbackFees;
        }
        return tokenOpsUsage.bytesNeededToRepr(numFixedHbarFees, numFixedHtsFees, numFractionalFees, numRoyaltyNoFallbackFees, numRoyaltyHtsFallbackFees, numRoyaltyHbarFallbackFees);
    }
}

