/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.NodeStake;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.EndOfStakingPeriodUtils;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHelper;
import com.hedera.node.app.service.token.records.NodeStakeUpdateStreamBuilder;
import com.hedera.node.app.service.token.records.TokenContext;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.StakingConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

@Singleton
public class EndOfStakingPeriodUpdater {
    private static final Logger log = LogManager.getLogger(EndOfStakingPeriodUpdater.class);
    private static final String END_OF_PERIOD_MEMO = "End of staking period calculation record";
    private static final MathContext MATH_CONTEXT = new MathContext(8, RoundingMode.DOWN);
    private final AccountsConfig accountsConfig;
    private final StakingRewardsHelper stakeRewardsHelper;
    private final EntityIdFactory entityIdFactory;

    @Inject
    public EndOfStakingPeriodUpdater(@NonNull StakingRewardsHelper stakeRewardsHelper, @NonNull ConfigProvider configProvider, @NonNull EntityIdFactory entityIdFactory) {
        this.stakeRewardsHelper = stakeRewardsHelper;
        VersionedConfiguration config = configProvider.getConfiguration();
        this.accountsConfig = (AccountsConfig)config.getConfigData(AccountsConfig.class);
        this.entityIdFactory = entityIdFactory;
    }

    @Nullable
    public StreamBuilder updateNodes(@NonNull TokenContext context, @NonNull ExchangeRateSet exchangeRates) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(exchangeRates);
        Instant consensusTime = context.consensusTime();
        log.info("Updating node stakes for a just-finished period @ {}", (Object)consensusTime);
        StakingConfig stakingConfig = (StakingConfig)context.configuration().getConfigData(StakingConfig.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)context.readableStore(ReadableAccountStore.class);
        WritableNetworkStakingRewardsStore stakingRewardsStore = (WritableNetworkStakingRewardsStore)context.writableStore(WritableNetworkStakingRewardsStore.class);
        long stakedToReward = stakingRewardsStore.totalStakeRewardStart();
        long maxRewardRate = this.rewardRateGiven(stakedToReward, accountStore, stakingRewardsStore, stakingConfig);
        log.info("The max reward rate for the ending period was {} tb/hbar for nodes with in-range stake, given {} total stake reward start", (Object)maxRewardRate, (Object)stakedToReward);
        HashMap<Long, Long> nodeRewardRates = new HashMap<Long, Long>();
        long newTotalStake = 0L;
        long newStakeToReward = 0L;
        WritableStakingInfoStore stakingInfoStore = (WritableStakingInfoStore)context.writableStore(WritableStakingInfoStore.class);
        ArrayList<NodeStake> nodeStakes = new ArrayList<NodeStake>();
        for (Long nodeId : context.knownNodeIds().stream().sorted().toList()) {
            StakingNodeInfo nodeInfo;
            EndOfStakingPeriodUtils.RewardSumHistory newRewardSumHistory = EndOfStakingPeriodUtils.computeExtendedRewardSumHistory(nodeInfo, (nodeInfo = Objects.requireNonNull(stakingInfoStore.get(nodeId))).deleted() ? 0L : maxRewardRate, stakingConfig.perHbarRewardRate(), stakingConfig.requireMinStakeToReward());
            long nodeRewardRate = newRewardSumHistory.pendingRewardRate();
            nodeRewardRates.put(nodeId, nodeRewardRate);
            nodeInfo = nodeInfo.copyBuilder().rewardSumHistory(newRewardSumHistory.rewardSumHistory()).build();
            log.info("Non-zero reward sum history for node number {} is now {}", new Supplier[]{() -> nodeId, () -> EndOfStakingPeriodUtils.readableNonZeroHistory(newRewardSumHistory.rewardSumHistory())});
            long pendingRewards = (nodeInfo.stakeRewardStart() - nodeInfo.unclaimedStakeRewardStart()) / 100000000L * nodeRewardRate;
            EndOfStakingPeriodUtils.StakeResult newStakes = EndOfStakingPeriodUtils.computeNewStakes(nodeInfo, stakingConfig);
            log.info("For node{}, the tb/hbar reward rate was {} for {} pending, with stake reward start {} -> {}", (Object)nodeId, (Object)nodeRewardRate, (Object)pendingRewards, (Object)nodeInfo.stakeRewardStart(), (Object)newStakes.stakeRewardStart());
            nodeInfo = nodeInfo.copyBuilder().stake(newStakes.stake()).stakeRewardStart(newStakes.stakeRewardStart()).unclaimedStakeRewardStart(0L).build();
            nodeInfo = this.stakeRewardsHelper.increasePendingRewardsBy(stakingRewardsStore, pendingRewards, nodeInfo);
            newStakeToReward += newStakes.stakeRewardStart();
            newTotalStake += nodeInfo.stake();
            if (!nodeInfo.deleted()) {
                nodeStakes.add(EndOfStakingPeriodUtils.fromStakingInfo((Long)nodeRewardRates.get(nodeId), nodeInfo));
            }
            stakingInfoStore.put(nodeId, nodeInfo);
        }
        stakingRewardsStore.put(EndOfStakingPeriodUtils.asStakingRewardBuilder(stakingRewardsStore).totalStakedRewardStart(newStakeToReward).totalStakedStart(newTotalStake).build());
        long rewardAccountBalance = this.getRewardsBalance(accountStore);
        log.info("Total stake start is now {} ({} rewarded), pending rewards are {} vs 0.0.800 balance {}", (Object)newTotalStake, (Object)newStakeToReward, (Object)stakingRewardsStore.pendingRewards(), (Object)rewardAccountBalance);
        long unreservedStakingRewardBalance = rewardAccountBalance - stakingRewardsStore.pendingRewards();
        TransactionBody.Builder syntheticNodeStakeUpdateTxn = EndOfStakingPeriodUtils.newNodeStakeUpdateBuilder(EndOfStakingPeriodUtils.lastInstantOfPreviousPeriodFor(consensusTime), nodeStakes, stakingConfig, stakedToReward, maxRewardRate, stakingRewardsStore.pendingRewards(), unreservedStakingRewardBalance, stakingConfig.rewardBalanceThreshold(), stakingConfig.maxStakeRewarded(), END_OF_PERIOD_MEMO);
        log.info("Exporting:\n{}", nodeStakes);
        return ((NodeStakeUpdateStreamBuilder)context.addPrecedingChildRecordBuilder(NodeStakeUpdateStreamBuilder.class, HederaFunctionality.NODE_STAKE_UPDATE)).signedTx(StreamBuilder.signedTxWith((TransactionBody)syntheticNodeStakeUpdateTxn.build())).memo(END_OF_PERIOD_MEMO).exchangeRate(exchangeRates).status(ResponseCodeEnum.SUCCESS);
    }

    private long rewardRateGiven(long stakedToReward, @NonNull ReadableAccountStore accountStore, @NonNull ReadableNetworkStakingRewardsStore networkRewardsStore, @NonNull StakingConfig stakingConfig) {
        long unreservedBalance = this.getRewardsBalance(accountStore) - networkRewardsStore.pendingRewards();
        BigDecimal balanceRatio = this.ratioOf(unreservedBalance, stakingConfig.rewardBalanceThreshold());
        long rewardRate = this.rescaledPerHbarRewardRate(balanceRatio, stakedToReward, stakingConfig.perHbarRewardRate(), stakingConfig.maxStakeRewarded());
        return stakedToReward < 100000000L ? 0L : rewardRate;
    }

    private BigDecimal ratioOf(long unreservedBalance, long thresholdBalance) {
        return thresholdBalance > 0L ? BigDecimal.valueOf(Math.min(unreservedBalance, thresholdBalance)).divide(BigDecimal.valueOf(thresholdBalance), MATH_CONTEXT) : BigDecimal.ONE;
    }

    @VisibleForTesting
    long rescaledPerHbarRewardRate(@NonNull BigDecimal balanceRatio, long stakedToReward, long maxRewardRate, long maxStakeRewarded) {
        return BigDecimal.valueOf(maxRewardRate).multiply(balanceRatio.multiply(BigDecimal.valueOf(2L).subtract(balanceRatio))).multiply(maxStakeRewarded >= stakedToReward ? BigDecimal.ONE : BigDecimal.valueOf(maxStakeRewarded).divide(BigDecimal.valueOf(stakedToReward), MATH_CONTEXT)).longValue();
    }

    private long getRewardsBalance(@NonNull ReadableAccountStore accountStore) {
        return Objects.requireNonNull(accountStore.getAccountById(this.entityIdFactory.newAccountId(this.accountsConfig.stakingRewardAccount()))).tinybarBalance();
    }
}

