/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.roster;

import com.hedera.hapi.node.state.primitives.ProtoBytes;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterState;
import com.hedera.hapi.node.state.roster.RoundRosterPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.hiero.consensus.roster.ReadableRosterStoreImpl;
import org.hiero.consensus.roster.RosterStateId;
import org.hiero.consensus.roster.RosterUtils;
import org.hiero.consensus.roster.RosterValidator;

public class WritableRosterStore
extends ReadableRosterStoreImpl {
    public static final int MAXIMUM_ROSTER_HISTORY_SIZE = 2;
    private final WritableSingletonState<RosterState> rosterState;
    private final WritableKVState<ProtoBytes, Roster> rosterMap;

    public WritableRosterStore(@NonNull WritableStates writableStates) {
        super((ReadableStates)writableStates);
        Objects.requireNonNull(writableStates);
        this.rosterState = writableStates.getSingleton(RosterStateId.ROSTER_STATE_STATE_ID);
        this.rosterMap = writableStates.get(RosterStateId.ROSTERS_STATE_ID);
    }

    public void adoptCandidateRoster(long roundNumber) {
        this.putActiveRoster(Objects.requireNonNull(this.getCandidateRoster()), roundNumber);
    }

    public void putCandidateRoster(@NonNull Roster candidateRoster) {
        Objects.requireNonNull(candidateRoster);
        RosterValidator.validate(candidateRoster);
        Bytes incomingCandidateRosterHash = RosterUtils.hash(candidateRoster).getBytes();
        RosterState previousRosterState = this.rosterStateOrDefault();
        Bytes previousCandidateRosterHash = previousRosterState.candidateRosterHash();
        RosterState.Builder newRosterStateBuilder = previousRosterState.copyBuilder().candidateRosterHash(incomingCandidateRosterHash);
        this.removeRoster(previousCandidateRosterHash);
        this.rosterState.put((Object)newRosterStateBuilder.build());
        this.rosterMap.put((Object)ProtoBytes.newBuilder().value(incomingCandidateRosterHash).build(), (Object)candidateRoster);
    }

    public void putActiveRoster(@NonNull Roster roster, long round) {
        Objects.requireNonNull(roster);
        RosterValidator.validate(roster);
        Bytes rosterHash = RosterUtils.hash(roster).getBytes();
        RosterState previousRosterState = this.rosterStateOrDefault();
        LinkedList<RoundRosterPair> roundRosterPairs = new LinkedList<RoundRosterPair>(previousRosterState.roundRosterPairs());
        if (!roundRosterPairs.isEmpty()) {
            RoundRosterPair activeRosterPair = (RoundRosterPair)roundRosterPairs.getFirst();
            if (activeRosterPair.activeRosterHash().equals((Object)rosterHash)) {
                return;
            }
            if (round < 0L || round <= activeRosterPair.roundNumber()) {
                throw new IllegalArgumentException("incoming round number = " + round + " must be greater than the round number of the current active roster = " + activeRosterPair.roundNumber() + ".");
            }
        }
        roundRosterPairs.addFirst(new RoundRosterPair(round, rosterHash));
        if (roundRosterPairs.size() > 2) {
            RoundRosterPair lastRemovedRoster = (RoundRosterPair)roundRosterPairs.removeLast();
            this.removeRoster(lastRemovedRoster.activeRosterHash());
            if (roundRosterPairs.size() > 2) {
                throw new IllegalStateException("Active rosters in the Roster state cannot be more than  2");
            }
        }
        RosterState.Builder newRosterStateBuilder = previousRosterState.copyBuilder().candidateRosterHash(Bytes.EMPTY).roundRosterPairs(roundRosterPairs);
        this.removeRoster(previousRosterState.candidateRosterHash());
        this.rosterState.put((Object)newRosterStateBuilder.build());
        this.rosterMap.put((Object)ProtoBytes.newBuilder().value(rosterHash).build(), (Object)roster);
    }

    public void updateTransplantInProgress(boolean inProgress) {
        RosterState currentRosterState = this.rosterStateOrDefault();
        RosterState.Builder newRosterStateBuilder = currentRosterState.copyBuilder().transplantInProgress(inProgress);
        this.rosterState.put((Object)newRosterStateBuilder.build());
    }

    public void resetRosters() {
        for (RoundRosterPair roundRosterPair : Objects.requireNonNull((RosterState)this.rosterState.get()).roundRosterPairs()) {
            this.rosterMap.remove((Object)new ProtoBytes(roundRosterPair.activeRosterHash()));
        }
        this.rosterMap.remove((Object)new ProtoBytes(Objects.requireNonNull((RosterState)this.rosterState.get()).candidateRosterHash()));
        this.rosterState.put((Object)RosterState.DEFAULT);
    }

    @NonNull
    private RosterState rosterStateOrDefault() {
        RosterState state = (RosterState)this.rosterState.get();
        return state == null ? RosterState.DEFAULT : state;
    }

    private void removeRoster(@NonNull Bytes rosterHash) {
        if (rosterHash.equals((Object)Bytes.EMPTY)) {
            return;
        }
        List activeRosterHistory = this.rosterStateOrDefault().roundRosterPairs();
        if (activeRosterHistory.stream().noneMatch(rosterPair -> rosterPair.activeRosterHash().equals((Object)rosterHash))) {
            this.rosterMap.remove((Object)ProtoBytes.newBuilder().value(rosterHash).build());
        }
    }
}

