/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class Schema {
    private final Set<ObjectClassInfo> _declaredObjectClasses;
    private final Set<OperationOptionInfo> _declaredOperationOptions;
    private final Map<Class<? extends APIOperation>, Set<ObjectClassInfo>> _supportedObjectClassesByOperation;
    private final Map<Class<? extends APIOperation>, Set<OperationOptionInfo>> _supportedOptionsByOperation;

    public Schema(Set<ObjectClassInfo> info, Set<OperationOptionInfo> options, Map<Class<? extends APIOperation>, Set<ObjectClassInfo>> supportedObjectClassesByOperation, Map<Class<? extends APIOperation>, Set<OperationOptionInfo>> supportedOptionsByOperation) {
        Set resolvedClasses;
        Class<? extends APIOperation> op;
        this._declaredObjectClasses = CollectionUtil.newReadOnlySet(info);
        this._declaredOperationOptions = CollectionUtil.newReadOnlySet(options);
        HashMap temp = new HashMap();
        for (Map.Entry<Class<? extends APIOperation>, Set<ObjectClassInfo>> entry : supportedObjectClassesByOperation.entrySet()) {
            op = entry.getKey();
            resolvedClasses = CollectionUtil.newReadOnlySet((Collection)entry.getValue());
            temp.put(op, resolvedClasses);
        }
        this._supportedObjectClassesByOperation = CollectionUtil.asReadOnlyMap(temp);
        temp = new HashMap();
        for (Map.Entry<Class<? extends APIOperation>, Set<Object>> entry : supportedOptionsByOperation.entrySet()) {
            op = entry.getKey();
            resolvedClasses = CollectionUtil.newReadOnlySet((Collection)entry.getValue());
            temp.put(op, resolvedClasses);
        }
        this._supportedOptionsByOperation = CollectionUtil.asReadOnlyMap(temp);
    }

    public Set<ObjectClassInfo> getObjectClassInfo() {
        return this._declaredObjectClasses;
    }

    public ObjectClassInfo findObjectClassInfo(String type) {
        Assertions.nullCheck(type, "type");
        for (ObjectClassInfo info : this._declaredObjectClasses) {
            if (!info.is(type)) continue;
            return info;
        }
        return null;
    }

    public Set<OperationOptionInfo> getOperationOptionInfo() {
        return this._declaredOperationOptions;
    }

    public OperationOptionInfo findOperationOptionInfo(String name) {
        Assertions.nullCheck(name, "name");
        for (OperationOptionInfo info : this._declaredOperationOptions) {
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    public Set<ObjectClassInfo> getSupportedObjectClassesByOperation(Class<? extends APIOperation> apiop) {
        Set<ObjectClassInfo> rv = this._supportedObjectClassesByOperation.get(apiop);
        if (rv == null) {
            Set empty = Collections.EMPTY_SET;
            return empty;
        }
        return rv;
    }

    public Set<OperationOptionInfo> getSupportedOptionsByOperation(Class<? extends APIOperation> apiop) {
        Set<OperationOptionInfo> rv = this._supportedOptionsByOperation.get(apiop);
        if (rv == null) {
            Set empty = Collections.EMPTY_SET;
            return empty;
        }
        return rv;
    }

    public Map<Class<? extends APIOperation>, Set<ObjectClassInfo>> getSupportedObjectClassesByOperation() {
        return this._supportedObjectClassesByOperation;
    }

    public Map<Class<? extends APIOperation>, Set<OperationOptionInfo>> getSupportedOptionsByOperation() {
        return this._supportedOptionsByOperation;
    }

    public String toString() {
        return SerializerUtil.serializeXmlObject(this, false);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Schema) {
            Schema other = (Schema)obj;
            if (!CollectionUtil.equals(this.getObjectClassInfo(), other.getObjectClassInfo())) {
                return false;
            }
            if (!CollectionUtil.equals(this.getOperationOptionInfo(), other.getOperationOptionInfo())) {
                return false;
            }
            if (!CollectionUtil.equals(this._supportedObjectClassesByOperation, other._supportedObjectClassesByOperation)) {
                return false;
            }
            return CollectionUtil.equals(this._supportedOptionsByOperation, other._supportedOptionsByOperation);
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this._declaredObjectClasses).hashCode();
    }
}

