/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.gascalculator.BerlinGasCalculator;
import org.hyperledger.besu.evm.gascalculator.ByzantiumGasCalculator;
import org.hyperledger.besu.evm.gascalculator.CancunGasCalculator;
import org.hyperledger.besu.evm.gascalculator.ConstantinopleGasCalculator;
import org.hyperledger.besu.evm.gascalculator.FrontierGasCalculator;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.gascalculator.HomesteadGasCalculator;
import org.hyperledger.besu.evm.gascalculator.IstanbulGasCalculator;
import org.hyperledger.besu.evm.gascalculator.LondonGasCalculator;
import org.hyperledger.besu.evm.gascalculator.PetersburgGasCalculator;
import org.hyperledger.besu.evm.gascalculator.PragueGasCalculator;
import org.hyperledger.besu.evm.gascalculator.ShanghaiGasCalculator;
import org.hyperledger.besu.evm.gascalculator.SpuriousDragonGasCalculator;
import org.hyperledger.besu.evm.gascalculator.TangerineWhistleGasCalculator;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.operation.AddModOperation;
import org.hyperledger.besu.evm.operation.AddOperation;
import org.hyperledger.besu.evm.operation.AddressOperation;
import org.hyperledger.besu.evm.operation.AndOperation;
import org.hyperledger.besu.evm.operation.BalanceOperation;
import org.hyperledger.besu.evm.operation.BaseFeeOperation;
import org.hyperledger.besu.evm.operation.BlobBaseFeeOperation;
import org.hyperledger.besu.evm.operation.BlobHashOperation;
import org.hyperledger.besu.evm.operation.BlockHashOperation;
import org.hyperledger.besu.evm.operation.ByteOperation;
import org.hyperledger.besu.evm.operation.CallCodeOperation;
import org.hyperledger.besu.evm.operation.CallDataCopyOperation;
import org.hyperledger.besu.evm.operation.CallDataLoadOperation;
import org.hyperledger.besu.evm.operation.CallDataSizeOperation;
import org.hyperledger.besu.evm.operation.CallFOperation;
import org.hyperledger.besu.evm.operation.CallOperation;
import org.hyperledger.besu.evm.operation.CallValueOperation;
import org.hyperledger.besu.evm.operation.CallerOperation;
import org.hyperledger.besu.evm.operation.ChainIdOperation;
import org.hyperledger.besu.evm.operation.CodeCopyOperation;
import org.hyperledger.besu.evm.operation.CodeSizeOperation;
import org.hyperledger.besu.evm.operation.CoinbaseOperation;
import org.hyperledger.besu.evm.operation.Create2Operation;
import org.hyperledger.besu.evm.operation.CreateOperation;
import org.hyperledger.besu.evm.operation.DelegateCallOperation;
import org.hyperledger.besu.evm.operation.DifficultyOperation;
import org.hyperledger.besu.evm.operation.DivOperation;
import org.hyperledger.besu.evm.operation.DupOperation;
import org.hyperledger.besu.evm.operation.EqOperation;
import org.hyperledger.besu.evm.operation.ExpOperation;
import org.hyperledger.besu.evm.operation.ExtCodeCopyOperation;
import org.hyperledger.besu.evm.operation.ExtCodeHashOperation;
import org.hyperledger.besu.evm.operation.ExtCodeSizeOperation;
import org.hyperledger.besu.evm.operation.GasLimitOperation;
import org.hyperledger.besu.evm.operation.GasOperation;
import org.hyperledger.besu.evm.operation.GasPriceOperation;
import org.hyperledger.besu.evm.operation.GtOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.IsZeroOperation;
import org.hyperledger.besu.evm.operation.JumpDestOperation;
import org.hyperledger.besu.evm.operation.JumpOperation;
import org.hyperledger.besu.evm.operation.JumpiOperation;
import org.hyperledger.besu.evm.operation.Keccak256Operation;
import org.hyperledger.besu.evm.operation.LogOperation;
import org.hyperledger.besu.evm.operation.LtOperation;
import org.hyperledger.besu.evm.operation.MCopyOperation;
import org.hyperledger.besu.evm.operation.MLoadOperation;
import org.hyperledger.besu.evm.operation.MSizeOperation;
import org.hyperledger.besu.evm.operation.MStore8Operation;
import org.hyperledger.besu.evm.operation.MStoreOperation;
import org.hyperledger.besu.evm.operation.ModOperation;
import org.hyperledger.besu.evm.operation.MulModOperation;
import org.hyperledger.besu.evm.operation.MulOperation;
import org.hyperledger.besu.evm.operation.NotOperation;
import org.hyperledger.besu.evm.operation.NumberOperation;
import org.hyperledger.besu.evm.operation.OperationRegistry;
import org.hyperledger.besu.evm.operation.OrOperation;
import org.hyperledger.besu.evm.operation.OriginOperation;
import org.hyperledger.besu.evm.operation.PCOperation;
import org.hyperledger.besu.evm.operation.PopOperation;
import org.hyperledger.besu.evm.operation.PrevRanDaoOperation;
import org.hyperledger.besu.evm.operation.Push0Operation;
import org.hyperledger.besu.evm.operation.PushOperation;
import org.hyperledger.besu.evm.operation.RelativeJumpIfOperation;
import org.hyperledger.besu.evm.operation.RelativeJumpOperation;
import org.hyperledger.besu.evm.operation.RelativeJumpVectorOperation;
import org.hyperledger.besu.evm.operation.RetFOperation;
import org.hyperledger.besu.evm.operation.ReturnDataCopyOperation;
import org.hyperledger.besu.evm.operation.ReturnDataSizeOperation;
import org.hyperledger.besu.evm.operation.ReturnOperation;
import org.hyperledger.besu.evm.operation.RevertOperation;
import org.hyperledger.besu.evm.operation.SDivOperation;
import org.hyperledger.besu.evm.operation.SGtOperation;
import org.hyperledger.besu.evm.operation.SLoadOperation;
import org.hyperledger.besu.evm.operation.SLtOperation;
import org.hyperledger.besu.evm.operation.SModOperation;
import org.hyperledger.besu.evm.operation.SStoreOperation;
import org.hyperledger.besu.evm.operation.SarOperation;
import org.hyperledger.besu.evm.operation.SelfBalanceOperation;
import org.hyperledger.besu.evm.operation.SelfDestructOperation;
import org.hyperledger.besu.evm.operation.ShlOperation;
import org.hyperledger.besu.evm.operation.ShrOperation;
import org.hyperledger.besu.evm.operation.SignExtendOperation;
import org.hyperledger.besu.evm.operation.StaticCallOperation;
import org.hyperledger.besu.evm.operation.StopOperation;
import org.hyperledger.besu.evm.operation.SubOperation;
import org.hyperledger.besu.evm.operation.SwapOperation;
import org.hyperledger.besu.evm.operation.TLoadOperation;
import org.hyperledger.besu.evm.operation.TStoreOperation;
import org.hyperledger.besu.evm.operation.TimestampOperation;
import org.hyperledger.besu.evm.operation.XorOperation;

public class MainnetEVMs {
    public static final BigInteger DEV_NET_CHAIN_ID = BigInteger.valueOf(1337L);
    public static final int SPURIOUS_DRAGON_CONTRACT_SIZE_LIMIT = 24576;
    public static final int SHANGHAI_INIT_CODE_SIZE_LIMIT = 49152;

    private MainnetEVMs() {
    }

    public static EVM frontier(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.frontier(new FrontierGasCalculator(), evmConfiguration);
    }

    public static EVM frontier(GasCalculator gasCalculator, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.frontierOperations(gasCalculator), gasCalculator, evmConfiguration, EvmSpecVersion.FRONTIER);
    }

    public static OperationRegistry frontierOperations(GasCalculator gasCalculator) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerFrontierOperations(operationRegistry, gasCalculator);
        return operationRegistry;
    }

    public static void registerFrontierOperations(OperationRegistry registry, GasCalculator gasCalculator) {
        int i;
        for (i = 0; i < 255; ++i) {
            registry.put(new InvalidOperation(i, gasCalculator));
        }
        registry.put(new AddOperation(gasCalculator));
        registry.put(new MulOperation(gasCalculator));
        registry.put(new SubOperation(gasCalculator));
        registry.put(new DivOperation(gasCalculator));
        registry.put(new SDivOperation(gasCalculator));
        registry.put(new ModOperation(gasCalculator));
        registry.put(new SModOperation(gasCalculator));
        registry.put(new ExpOperation(gasCalculator));
        registry.put(new AddModOperation(gasCalculator));
        registry.put(new MulModOperation(gasCalculator));
        registry.put(new SignExtendOperation(gasCalculator));
        registry.put(new LtOperation(gasCalculator));
        registry.put(new GtOperation(gasCalculator));
        registry.put(new SLtOperation(gasCalculator));
        registry.put(new SGtOperation(gasCalculator));
        registry.put(new EqOperation(gasCalculator));
        registry.put(new IsZeroOperation(gasCalculator));
        registry.put(new AndOperation(gasCalculator));
        registry.put(new OrOperation(gasCalculator));
        registry.put(new XorOperation(gasCalculator));
        registry.put(new NotOperation(gasCalculator));
        registry.put(new ByteOperation(gasCalculator));
        registry.put(new Keccak256Operation(gasCalculator));
        registry.put(new AddressOperation(gasCalculator));
        registry.put(new BalanceOperation(gasCalculator));
        registry.put(new OriginOperation(gasCalculator));
        registry.put(new CallerOperation(gasCalculator));
        registry.put(new CallValueOperation(gasCalculator));
        registry.put(new CallDataLoadOperation(gasCalculator));
        registry.put(new CallDataSizeOperation(gasCalculator));
        registry.put(new CallDataCopyOperation(gasCalculator));
        registry.put(new CodeSizeOperation(gasCalculator));
        registry.put(new CodeCopyOperation(gasCalculator));
        registry.put(new GasPriceOperation(gasCalculator));
        registry.put(new ExtCodeCopyOperation(gasCalculator));
        registry.put(new ExtCodeSizeOperation(gasCalculator));
        registry.put(new BlockHashOperation(gasCalculator));
        registry.put(new CoinbaseOperation(gasCalculator));
        registry.put(new TimestampOperation(gasCalculator));
        registry.put(new NumberOperation(gasCalculator));
        registry.put(new DifficultyOperation(gasCalculator));
        registry.put(new GasLimitOperation(gasCalculator));
        registry.put(new PopOperation(gasCalculator));
        registry.put(new MLoadOperation(gasCalculator));
        registry.put(new MStoreOperation(gasCalculator));
        registry.put(new MStore8Operation(gasCalculator));
        registry.put(new SLoadOperation(gasCalculator));
        registry.put(new SStoreOperation(gasCalculator, 0L));
        registry.put(new JumpOperation(gasCalculator));
        registry.put(new JumpiOperation(gasCalculator));
        registry.put(new PCOperation(gasCalculator));
        registry.put(new MSizeOperation(gasCalculator));
        registry.put(new GasOperation(gasCalculator));
        registry.put(new JumpDestOperation(gasCalculator));
        registry.put(new ReturnOperation(gasCalculator));
        registry.put(new InvalidOperation(gasCalculator));
        registry.put(new StopOperation(gasCalculator));
        registry.put(new SelfDestructOperation(gasCalculator));
        registry.put(new CreateOperation(gasCalculator, Integer.MAX_VALUE));
        registry.put(new CallOperation(gasCalculator));
        registry.put(new CallCodeOperation(gasCalculator));
        for (i = 1; i <= 32; ++i) {
            registry.put(new PushOperation(i, gasCalculator));
        }
        for (i = 1; i <= 16; ++i) {
            registry.put(new DupOperation(i, gasCalculator));
        }
        for (i = 1; i <= 16; ++i) {
            registry.put(new SwapOperation(i, gasCalculator));
        }
        for (i = 0; i < 5; ++i) {
            registry.put(new LogOperation(i, gasCalculator));
        }
    }

    public static EVM homestead(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.homestead(new HomesteadGasCalculator(), evmConfiguration);
    }

    public static EVM homestead(GasCalculator gasCalculator, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.homesteadOperations(gasCalculator), gasCalculator, evmConfiguration, EvmSpecVersion.HOMESTEAD);
    }

    public static OperationRegistry homesteadOperations(GasCalculator gasCalculator) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerHomesteadOperations(operationRegistry, gasCalculator);
        return operationRegistry;
    }

    public static void registerHomesteadOperations(OperationRegistry registry, GasCalculator gasCalculator) {
        MainnetEVMs.registerFrontierOperations(registry, gasCalculator);
        registry.put(new DelegateCallOperation(gasCalculator));
    }

    public static EVM spuriousDragon(EvmConfiguration evmConfiguration) {
        SpuriousDragonGasCalculator gasCalculator = new SpuriousDragonGasCalculator();
        return new EVM(MainnetEVMs.homesteadOperations(gasCalculator), gasCalculator, evmConfiguration, EvmSpecVersion.SPURIOUS_DRAGON);
    }

    public static EVM tangerineWhistle(EvmConfiguration evmConfiguration) {
        TangerineWhistleGasCalculator gasCalculator = new TangerineWhistleGasCalculator();
        return new EVM(MainnetEVMs.homesteadOperations(gasCalculator), gasCalculator, evmConfiguration, EvmSpecVersion.TANGERINE_WHISTLE);
    }

    public static EVM byzantium(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.byzantium(new ByzantiumGasCalculator(), evmConfiguration);
    }

    public static EVM byzantium(GasCalculator gasCalculator, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.byzantiumOperations(gasCalculator), gasCalculator, evmConfiguration, EvmSpecVersion.BYZANTIUM);
    }

    public static OperationRegistry byzantiumOperations(GasCalculator gasCalculator) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerByzantiumOperations(operationRegistry, gasCalculator);
        return operationRegistry;
    }

    public static void registerByzantiumOperations(OperationRegistry registry, GasCalculator gasCalculator) {
        MainnetEVMs.registerHomesteadOperations(registry, gasCalculator);
        registry.put(new ReturnDataCopyOperation(gasCalculator));
        registry.put(new ReturnDataSizeOperation(gasCalculator));
        registry.put(new RevertOperation(gasCalculator));
        registry.put(new StaticCallOperation(gasCalculator));
    }

    public static EVM constantinople(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.constantinople(new ConstantinopleGasCalculator(), evmConfiguration);
    }

    public static EVM constantinople(GasCalculator gasCalculator, EvmConfiguration evmConfiguration) {
        EvmSpecVersion version = EvmSpecVersion.CONSTANTINOPLE;
        return MainnetEVMs.constantiNOPEl(gasCalculator, evmConfiguration, version);
    }

    private static EVM constantiNOPEl(GasCalculator gasCalculator, EvmConfiguration evmConfiguration, EvmSpecVersion version) {
        return new EVM(MainnetEVMs.constantinopleOperations(gasCalculator), gasCalculator, evmConfiguration, version);
    }

    public static OperationRegistry constantinopleOperations(GasCalculator gasCalculator) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerConstantinopleOperations(operationRegistry, gasCalculator);
        return operationRegistry;
    }

    public static void registerConstantinopleOperations(OperationRegistry registry, GasCalculator gasCalculator) {
        MainnetEVMs.registerByzantiumOperations(registry, gasCalculator);
        registry.put(new Create2Operation(gasCalculator, Integer.MAX_VALUE));
        registry.put(new SarOperation(gasCalculator));
        registry.put(new ShlOperation(gasCalculator));
        registry.put(new ShrOperation(gasCalculator));
        registry.put(new ExtCodeHashOperation(gasCalculator));
    }

    public static EVM petersburg(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.constantiNOPEl(new PetersburgGasCalculator(), evmConfiguration, EvmSpecVersion.PETERSBURG);
    }

    public static EVM istanbul(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.istanbul(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM istanbul(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.istanbul(new IstanbulGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM istanbul(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.istanbulOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.ISTANBUL);
    }

    public static OperationRegistry istanbulOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerIstanbulOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerIstanbulOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainId) {
        MainnetEVMs.registerConstantinopleOperations(registry, gasCalculator);
        registry.put(new ChainIdOperation(gasCalculator, Bytes32.leftPad((Bytes)Bytes.of((byte[])chainId.toByteArray()))));
        registry.put(new SelfBalanceOperation(gasCalculator));
        registry.put(new SStoreOperation(gasCalculator, 2300L));
    }

    public static EVM berlin(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.berlin(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM berlin(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.berlin(new BerlinGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM berlin(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.istanbulOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.BERLIN);
    }

    public static EVM london(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.london(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM london(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.london(new LondonGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM london(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.londonOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.LONDON);
    }

    public static OperationRegistry londonOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerLondonOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerLondonOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainId) {
        MainnetEVMs.registerIstanbulOperations(registry, gasCalculator, chainId);
        registry.put(new BaseFeeOperation(gasCalculator));
    }

    public static EVM paris(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.paris(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM paris(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.paris(new LondonGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM paris(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.parisOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.PARIS);
    }

    public static OperationRegistry parisOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerParisOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerParisOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerLondonOperations(registry, gasCalculator, chainID);
        registry.put(new PrevRanDaoOperation(gasCalculator));
    }

    public static EVM shanghai(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.shanghai(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM shanghai(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.shanghai(new ShanghaiGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM shanghai(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.shanghaiOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.SHANGHAI);
    }

    public static OperationRegistry shanghaiOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerShanghaiOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerShanghaiOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerParisOperations(registry, gasCalculator, chainID);
        registry.put(new Push0Operation(gasCalculator));
        registry.put(new CreateOperation(gasCalculator, 49152));
        registry.put(new Create2Operation(gasCalculator, 49152));
    }

    public static EVM cancun(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.cancun(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM cancun(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.cancun(new CancunGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM cancun(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.cancunOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.CANCUN);
    }

    public static OperationRegistry cancunOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerCancunOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerCancunOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerShanghaiOperations(registry, gasCalculator, chainID);
        registry.put(new TStoreOperation(gasCalculator));
        registry.put(new TLoadOperation(gasCalculator));
        registry.put(new BlobHashOperation(gasCalculator));
        registry.put(new MCopyOperation(gasCalculator));
        registry.put(new SelfDestructOperation(gasCalculator, true));
        registry.put(new BlobBaseFeeOperation(gasCalculator));
    }

    public static EVM prague(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.prague(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM prague(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.prague(new PragueGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM prague(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.pragueOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.PRAGUE);
    }

    public static OperationRegistry pragueOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerPragueOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerPragueOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerCancunOperations(registry, gasCalculator, chainID);
    }

    public static EVM osaka(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.osaka(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM osaka(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.osaka(new PragueGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM osaka(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.osakaOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.OSAKA);
    }

    public static OperationRegistry osakaOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerOsakaOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerOsakaOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerPragueOperations(registry, gasCalculator, chainID);
    }

    public static EVM bogota(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.bogota(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM bogota(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.bogota(new PragueGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM bogota(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.bogotaOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.BOGOTA);
    }

    public static OperationRegistry bogotaOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerBogotaOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerBogotaOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerOsakaOperations(registry, gasCalculator, chainID);
    }

    public static EVM futureEips(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.futureEips(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM futureEips(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.futureEips(new PragueGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM futureEips(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.futureEipsOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.FUTURE_EIPS);
    }

    public static OperationRegistry futureEipsOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerFutureEipsOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerFutureEipsOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerBogotaOperations(registry, gasCalculator, chainID);
        registry.put(new RelativeJumpOperation(gasCalculator));
        registry.put(new RelativeJumpIfOperation(gasCalculator));
        registry.put(new RelativeJumpVectorOperation(gasCalculator));
        registry.put(new CallFOperation(gasCalculator));
        registry.put(new RetFOperation(gasCalculator));
    }

    public static EVM experimentalEips(EvmConfiguration evmConfiguration) {
        return MainnetEVMs.experimentalEips(DEV_NET_CHAIN_ID, evmConfiguration);
    }

    public static EVM experimentalEips(BigInteger chainId, EvmConfiguration evmConfiguration) {
        return MainnetEVMs.experimentalEips(new PragueGasCalculator(), chainId, evmConfiguration);
    }

    public static EVM experimentalEips(GasCalculator gasCalculator, BigInteger chainId, EvmConfiguration evmConfiguration) {
        return new EVM(MainnetEVMs.experimentalEipsOperations(gasCalculator, chainId), gasCalculator, evmConfiguration, EvmSpecVersion.EXPERIMENTAL_EIPS);
    }

    public static OperationRegistry experimentalEipsOperations(GasCalculator gasCalculator, BigInteger chainId) {
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerExperimentalEipsOperations(operationRegistry, gasCalculator, chainId);
        return operationRegistry;
    }

    public static void registerExperimentalEipsOperations(OperationRegistry registry, GasCalculator gasCalculator, BigInteger chainID) {
        MainnetEVMs.registerFutureEipsOperations(registry, gasCalculator, chainID);
    }
}

