/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import java.io.ByteArrayInputStream;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.code.CodeSection;

public class EOFLayout {
    static final int SECTION_TERMINATOR = 0;
    static final int SECTION_TYPES = 1;
    static final int SECTION_CODE = 2;
    static final int SECTION_DATA = 3;
    static final int MAX_SUPPORTED_VERSION = 1;
    private final Bytes container;
    private final int version;
    private final CodeSection[] codeSections;
    private final String invalidReason;

    private EOFLayout(Bytes container, int version, CodeSection[] codeSections) {
        this.container = container;
        this.version = version;
        this.codeSections = codeSections;
        this.invalidReason = null;
    }

    private EOFLayout(Bytes container, int version, String invalidReason) {
        this.container = container;
        this.version = version;
        this.codeSections = null;
        this.invalidReason = invalidReason;
    }

    private static EOFLayout invalidLayout(Bytes container, int version, String invalidReason) {
        return new EOFLayout(container, version, invalidReason);
    }

    private static String readKind(ByteArrayInputStream inputStream, int expectedKind) {
        int kind = inputStream.read();
        if (kind == -1) {
            return "Improper section headers";
        }
        if (kind != expectedKind) {
            return "Expected kind " + expectedKind + " but read kind " + kind;
        }
        return null;
    }

    public static EOFLayout parseEOF(Bytes container) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(container.toArrayUnsafe());
        if (inputStream.available() < 3) {
            return EOFLayout.invalidLayout(container, -1, "EOF Container too small");
        }
        if (inputStream.read() != 239) {
            return EOFLayout.invalidLayout(container, -1, "EOF header byte 0 incorrect");
        }
        if (inputStream.read() != 0) {
            return EOFLayout.invalidLayout(container, -1, "EOF header byte 1 incorrect");
        }
        int version = inputStream.read();
        if (version > 1 || version < 1) {
            return EOFLayout.invalidLayout(container, version, "Unsupported EOF Version " + version);
        }
        String error = EOFLayout.readKind(inputStream, 1);
        if (error != null) {
            return EOFLayout.invalidLayout(container, version, error);
        }
        int typesLength = EOFLayout.readUnsignedShort(inputStream);
        if (typesLength <= 0) {
            return EOFLayout.invalidLayout(container, version, "Invalid Types section size");
        }
        error = EOFLayout.readKind(inputStream, 2);
        if (error != null) {
            return EOFLayout.invalidLayout(container, version, error);
        }
        int codeSectionCount = EOFLayout.readUnsignedShort(inputStream);
        if (codeSectionCount <= 0) {
            return EOFLayout.invalidLayout(container, version, "Invalid Code section count");
        }
        if (codeSectionCount * 4 != typesLength) {
            return EOFLayout.invalidLayout(container, version, "Type section length incompatible with code section count - 0x" + Integer.toHexString(codeSectionCount) + " * 4 != 0x" + Integer.toHexString(typesLength));
        }
        if (codeSectionCount > 1024) {
            return EOFLayout.invalidLayout(container, version, "Too many code sections - 0x" + Integer.toHexString(codeSectionCount));
        }
        int[] codeSectionSizes = new int[codeSectionCount];
        for (int i = 0; i < codeSectionCount; ++i) {
            int size = EOFLayout.readUnsignedShort(inputStream);
            if (size <= 0) {
                return EOFLayout.invalidLayout(container, version, "Invalid Code section size for section " + i);
            }
            codeSectionSizes[i] = size;
        }
        error = EOFLayout.readKind(inputStream, 3);
        if (error != null) {
            return EOFLayout.invalidLayout(container, version, error);
        }
        int dataSize = EOFLayout.readUnsignedShort(inputStream);
        if (dataSize < 0) {
            return EOFLayout.invalidLayout(container, version, "Invalid Data section size");
        }
        error = EOFLayout.readKind(inputStream, 0);
        if (error != null) {
            return EOFLayout.invalidLayout(container, version, error);
        }
        int[][] typeData = new int[codeSectionCount][3];
        for (int i = 0; i < codeSectionCount; ++i) {
            typeData[i][0] = inputStream.read();
            typeData[i][1] = inputStream.read();
            typeData[i][2] = EOFLayout.readUnsignedShort(inputStream);
        }
        if (typeData[codeSectionCount - 1][2] == -1) {
            return EOFLayout.invalidLayout(container, version, "Incomplete type section");
        }
        if (typeData[0][0] != 0 || (typeData[0][1] & 0x7F) != 0) {
            return EOFLayout.invalidLayout(container, version, "Code section does not have zero inputs and outputs");
        }
        CodeSection[] codeSections = new CodeSection[codeSectionCount];
        int pos = 9 + codeSectionCount * 2 + 3 + 1 + codeSectionCount * 4;
        for (int i = 0; i < codeSectionCount; ++i) {
            int codeSectionSize = codeSectionSizes[i];
            if (inputStream.skip(codeSectionSize) != (long)codeSectionSize) {
                return EOFLayout.invalidLayout(container, version, "Incomplete code section " + i);
            }
            if (typeData[i][0] > 127) {
                return EOFLayout.invalidLayout(container, version, "Type data input stack too large - 0x" + Integer.toHexString(typeData[i][0]));
            }
            if (typeData[i][1] > 128) {
                return EOFLayout.invalidLayout(container, version, "Type data output stack too large - 0x" + Integer.toHexString(typeData[i][1]));
            }
            if (typeData[i][2] > 1023) {
                return EOFLayout.invalidLayout(container, version, "Type data max stack too large - 0x" + Integer.toHexString(typeData[i][2]));
            }
            codeSections[i] = new CodeSection(codeSectionSize, typeData[i][0], typeData[i][1], typeData[i][2], pos);
            pos += codeSectionSize;
        }
        if (inputStream.skip(dataSize) != (long)dataSize) {
            return EOFLayout.invalidLayout(container, version, "Incomplete data section");
        }
        if (inputStream.read() != -1) {
            return EOFLayout.invalidLayout(container, version, "Dangling data after end of all sections");
        }
        return new EOFLayout(container, version, codeSections);
    }

    static int readUnsignedShort(ByteArrayInputStream inputStream) {
        if (inputStream.available() < 2) {
            return -1;
        }
        return inputStream.read() << 8 | inputStream.read();
    }

    public Bytes getContainer() {
        return this.container;
    }

    public int getVersion() {
        return this.version;
    }

    public int getCodeSectionCount() {
        return this.codeSections == null ? 0 : this.codeSections.length;
    }

    public CodeSection getCodeSection(int i) {
        return this.codeSections[i];
    }

    public String getInvalidReason() {
        return this.invalidReason;
    }

    public boolean isValid() {
        return this.invalidReason == null;
    }
}

