/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class NotOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult notSuccess = new Operation.OperationResult(3L, null);

    public NotOperation(GasCalculator gasCalculator) {
        super(25, "NOT", 1, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return NotOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes32 value = Bytes32.leftPad((Bytes)frame.popStackItem());
        Bytes result = value.not();
        frame.pushStackItem(result);
        return notSuccess;
    }
}

