/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.AccessListEntry;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.BlobsWithCommitments;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Quantity;
import org.hyperledger.besu.datatypes.TransactionType;
import org.hyperledger.besu.datatypes.VersionedHash;

public interface Transaction {
    public Hash getHash();

    public long getNonce();

    public Optional<? extends Quantity> getGasPrice();

    default public Optional<? extends Quantity> getMaxPriorityFeePerGas() {
        return Optional.empty();
    }

    default public Optional<? extends Quantity> getMaxFeePerGas() {
        return Optional.empty();
    }

    default public Optional<? extends Quantity> getMaxFeePerBlobGas() {
        return Optional.empty();
    }

    public long getGasLimit();

    public Optional<? extends Address> getTo();

    public Quantity getValue();

    public BigInteger getYParity();

    public BigInteger getV();

    public BigInteger getR();

    public BigInteger getS();

    public Address getSender();

    public Optional<BigInteger> getChainId();

    public Optional<Bytes> getInit();

    public Optional<Bytes> getData();

    public Bytes getPayload();

    public TransactionType getType();

    public Optional<List<VersionedHash>> getVersionedHashes();

    public Optional<BlobsWithCommitments> getBlobsWithCommitments();

    public Optional<Address> contractAddress();

    public Optional<List<AccessListEntry>> getAccessList();

    public Bytes encoded();

    public int getSize();
}

