/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.getscheduledinfo;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.getscheduledinfo.GetScheduledFungibleTokenCreateCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.getscheduledinfo.GetScheduledNonFungibleTokenCreateCall;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class GetScheduledInfoTranslator
extends AbstractCallTranslator<HssCallAttempt> {
    public static final SystemContractMethod GET_SCHEDULED_CREATE_FUNGIBLE_TOKEN_INFO = SystemContractMethod.declare("getScheduledCreateFungibleTokenInfo(address)", "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(uint32,address,uint32)),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int32))").withCategories(SystemContractMethod.Category.SCHEDULE).withVariant(SystemContractMethod.Variant.FT);
    public static final SystemContractMethod GET_SCHEDULED_CREATE_NON_FUNGIBLE_TOKEN_INFO = SystemContractMethod.declare("getScheduledCreateNonFungibleTokenInfo(address)", "(int32,(((string,string,address,string,bool,int64,bool,(uint256,(bool,address,bytes,bytes,address))[],(uint32,address,uint32)),int64,bool,bool,bool,(uint32,address,bool,bool,address)[],(uint32,uint32,uint32,uint32,bool,address)[],(uint32,uint32,uint32,address,bool,address)[],string),int64,address,int64,bytes,address))").withCategories(SystemContractMethod.Category.SCHEDULE).withVariant(SystemContractMethod.Variant.NFT);
    private static final int SCHEDULE_ADDRESS = 0;

    @Inject
    public GetScheduledInfoTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HSS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(GET_SCHEDULED_CREATE_FUNGIBLE_TOKEN_INFO, GET_SCHEDULED_CREATE_NON_FUNGIBLE_TOKEN_INFO);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HssCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        return attempt.isMethod(GET_SCHEDULED_CREATE_FUNGIBLE_TOKEN_INFO, GET_SCHEDULED_CREATE_NON_FUNGIBLE_TOKEN_INFO);
    }

    @Override
    public Call callFrom(@NonNull HssCallAttempt attempt) {
        return attempt.isSelector(GET_SCHEDULED_CREATE_FUNGIBLE_TOKEN_INFO) ? this.getFungibleTokenCreateCall(attempt) : this.getNonFungibleTokenCreateCall(attempt);
    }

    private Call getFungibleTokenCreateCall(@NonNull HssCallAttempt attempt) {
        Tuple call = GET_SCHEDULED_CREATE_FUNGIBLE_TOKEN_INFO.decodeCall(attempt.inputBytes());
        Address scheduleAddress = (Address)call.get(0);
        return new GetScheduledFungibleTokenCreateCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.configuration(), ConversionUtils.addressToScheduleID(attempt.nativeOperations().entityIdFactory(), scheduleAddress));
    }

    private Call getNonFungibleTokenCreateCall(@NonNull HssCallAttempt attempt) {
        Tuple call = GET_SCHEDULED_CREATE_NON_FUNGIBLE_TOKEN_INFO.decodeCall(attempt.inputBytes());
        Address scheduleAddress = (Address)call.get(0);
        return new GetScheduledNonFungibleTokenCreateCall(attempt.systemContractGasCalculator(), attempt.enhancement(), attempt.configuration(), ConversionUtils.addressToScheduleID(attempt.nativeOperations().entityIdFactory(), scheduleAddress));
    }
}

