/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.handlers;

import com.hedera.hapi.node.base.HookId;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.hooks.HookCreation;
import com.hedera.hapi.node.hooks.HookCreationDetails;
import com.hedera.hapi.node.hooks.HookDispatchTransactionBody;
import com.hedera.hapi.node.state.hooks.EvmHookState;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.contract.impl.utils.HookValidationUtils;
import com.hedera.node.app.service.token.records.HookDispatchStreamBuilder;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.HooksConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;

public class HookDispatchHandler
implements TransactionHandler {
    @Inject
    public HookDispatchHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        HookDispatchTransactionBody op = context.body().hookDispatchOrThrow();
        PreCheckException.validateTruePreCheck((op.hasCreation() || op.hasExecution() || op.hasHookIdToDelete() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        if (op.hasCreation()) {
            HookValidationUtils.validateHook(op.creationOrThrow().details());
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        WritableEvmHookStore evmHookStore = (WritableEvmHookStore)context.storeFactory().writableStore(WritableEvmHookStore.class);
        HookDispatchTransactionBody op = context.body().hookDispatchOrThrow();
        HookDispatchStreamBuilder recordBuilder = (HookDispatchStreamBuilder)context.savepointStack().getBaseBuilder(HookDispatchStreamBuilder.class);
        HooksConfig hookConfig = (HooksConfig)context.configuration().getConfigData(HooksConfig.class);
        HandleException.validateTrue((boolean)hookConfig.hooksEnabled(), (ResponseCodeEnum)ResponseCodeEnum.HOOKS_NOT_ENABLED);
        switch ((HookDispatchTransactionBody.ActionOneOfType)op.action().kind()) {
            case CREATION: {
                HookCreation creation = op.creationOrThrow();
                HookCreationDetails details = creation.details();
                EvmHookState hook = evmHookStore.getEvmHook(new HookId(creation.entityId(), details.hookId()));
                HandleException.validateTrue((hook == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_ID_IN_USE);
                if (details.hasAdminKey()) {
                    context.attributeValidator().validateKey(details.adminKeyOrThrow(), ResponseCodeEnum.INVALID_HOOK_ADMIN_KEY);
                }
                evmHookStore.createEvmHook(op.creationOrThrow());
                break;
            }
            case HOOK_ID_TO_DELETE: {
                HookId deletion = op.hookIdToDeleteOrThrow();
                EvmHookState hook = evmHookStore.getEvmHook(new HookId(deletion.entityId(), deletion.hookId()));
                HandleException.validateTrue((hook != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_NOT_FOUND);
                HandleException.validateTrue((!hook.deleted() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.HOOK_DELETED);
                recordBuilder.nextHookId(hook.nextHookId().longValue());
                evmHookStore.removeOrMarkDeleted(op.hookIdToDeleteOrThrow());
                break;
            }
            case EXECUTION: {
                throw new UnsupportedOperationException("EVM hook execution not implemented yet");
            }
        }
    }
}

