/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.TransactionProcessor;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransactionResult;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmVersion;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class HederaEvmTransactionProcessor {
    private final Map<HederaEvmVersion, TransactionProcessor> transactionProcessors;

    @Inject
    public HederaEvmTransactionProcessor(@NonNull Map<HederaEvmVersion, TransactionProcessor> transactionProcessors) {
        this.transactionProcessors = Objects.requireNonNull(transactionProcessors);
    }

    public HederaEvmTransactionResult process(@NonNull HederaEvmTransaction transaction, @NonNull HederaWorldUpdater updater, @NonNull HederaEvmContext context, @NonNull HederaEvmVersion version, @NonNull ActionSidecarContentTracer tracer, @NonNull Configuration config, @NonNull OpsDurationCounter opsDurationCounter) {
        return Objects.requireNonNull(this.transactionProcessors.get((Object)version)).processTransaction(Objects.requireNonNull(transaction), Objects.requireNonNull(updater), Objects.requireNonNull(context), Objects.requireNonNull(tracer), Objects.requireNonNull(config), Objects.requireNonNull(opsDurationCounter));
    }
}

