/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.node.app.spi.records.BlockRecordInfo;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.frame.BlockValues;

public record HevmBlockValues(long gasLimit, long blockNo, @NonNull Timestamp blockTime) implements BlockValues
{
    private static final Optional<Wei> ZERO_BASE_FEE = Optional.of(Wei.ZERO);

    public HevmBlockValues {
        Objects.requireNonNull(blockTime);
    }

    public static HevmBlockValues from(@NonNull BlockRecordInfo blockRecordInfo, long gasLimit) {
        Objects.requireNonNull(blockRecordInfo);
        return new HevmBlockValues(gasLimit, blockRecordInfo.blockNo(), blockRecordInfo.blockTimestamp());
    }

    public long getGasLimit() {
        return this.gasLimit;
    }

    public long getTimestamp() {
        return this.blockTime.seconds();
    }

    public Optional<Wei> getBaseFee() {
        return ZERO_BASE_FEE;
    }

    public Bytes getDifficultyBytes() {
        return Bytes.EMPTY;
    }

    public long getNumber() {
        return this.blockNo;
    }
}

