/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.swirlds.platform.consensus.AncestorIterator;
import com.swirlds.platform.consensus.EventVisitedMark;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;

public class AncestorSearch {
    private final AncestorIterator iterator;

    public AncestorSearch() {
        this(new EventVisitedMark());
    }

    public AncestorSearch(@NonNull EventVisitedMark mark) {
        this.iterator = new AncestorIterator(mark);
    }

    @NonNull
    public AncestorIterator initializeSearch(@NonNull EventImpl root, @NonNull Predicate<EventImpl> valid) {
        this.iterator.initializeSearch(root, valid);
        return this.iterator;
    }

    @NonNull
    public List<EventImpl> commonAncestorsOf(@NonNull List<EventImpl> events, @NonNull Predicate<EventImpl> valid) {
        ArrayList<EventImpl> visited = new ArrayList<EventImpl>();
        for (EventImpl e : events) {
            AncestorIterator validAncestors = this.initializeSearch(e, valid);
            while (validAncestors.hasNext()) {
                EventImpl event = validAncestors.next();
                if (event.getRecTimes() == null) {
                    event.setRecTimes(new ArrayList<Instant>());
                    visited.add(event);
                }
                event.getRecTimes().add(validAncestors.getTime());
            }
        }
        ArrayList<EventImpl> commonAncestors = new ArrayList<EventImpl>();
        for (EventImpl e : visited) {
            if (e.getRecTimes().size() == events.size()) {
                commonAncestors.add(e);
                Collections.sort(e.getRecTimes());
                continue;
            }
            e.setRecTimes(null);
        }
        return commonAncestors;
    }
}

