/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health.filesystem;

import com.swirlds.platform.health.OSHealthCheckUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class OSFileSystemCheck {
    private static final long DEFAULT_READ_TIMEOUT_MILLIS = 20L;

    private OSFileSystemCheck() {
    }

    public static Report execute(Path fileToRead) throws InterruptedException {
        return OSFileSystemCheck.execute(fileToRead, 20L);
    }

    public static Report execute(Path fileToRead, long timeoutMillis) throws InterruptedException {
        if (!Files.exists(fileToRead, new LinkOption[0])) {
            return Report.failure(TestResultCode.FILE_DOES_NOT_EXIST);
        }
        if (Files.isDirectory(fileToRead, new LinkOption[0])) {
            return Report.failure(TestResultCode.FILE_IS_DIRECTORY);
        }
        if (!Files.isReadable(fileToRead)) {
            return Report.failure(TestResultCode.FILE_NOT_READABLE);
        }
        AtomicReference failureReport = new AtomicReference();
        Supplier<Byte> randomRequester = () -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        };
        OSHealthCheckUtils.SupplierResult<Byte> result = OSHealthCheckUtils.timeSupplier(randomRequester, timeoutMillis);
        if (failureReport.get() != null) {
            return (Report)failureReport.get();
        }
        if (result == null) {
            return Report.failure(TestResultCode.TIMED_OUT);
        }
        long elapsedNanos = result.duration().toNanos();
        Byte byteRead = result.result();
        return Report.success(elapsedNanos, byteRead.byteValue());
    }

    public record Report(TestResultCode code, Long readNanos, Integer data, Exception exception) {
        private static final String NAME = "File System Check";

        public static Report failure(TestResultCode code) {
            return new Report(code, null, null, null);
        }

        public static Report failure(TestResultCode code, Exception e) {
            return new Report(code, null, null, e);
        }

        public static Report success(long readNanos, int byteRead) {
            return new Report(TestResultCode.SUCCESS, readNanos, byteRead, null);
        }

        public static String name() {
            return NAME;
        }
    }

    public static enum TestResultCode {
        SUCCESS,
        FILE_DOES_NOT_EXIST,
        FILE_IS_DIRECTORY,
        FILE_NOT_READABLE,
        TIMED_OUT,
        FILE_EMPTY,
        EXCEPTION;

    }
}

