/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.network.communication;

import com.swirlds.platform.network.communication.NegotiationException;
import com.swirlds.platform.network.protocol.PeerProtocol;
import java.util.List;

public class NegotiationProtocols {
    private final PeerProtocol[] allPeerProtocols;
    private PeerProtocol initiatedPeerProtocol = null;

    public NegotiationProtocols(List<PeerProtocol> peerProtocols) {
        if (peerProtocols == null || peerProtocols.isEmpty() || peerProtocols.size() > 252) {
            throw new IllegalArgumentException("the list of protocols supplied should be: non-null, non-empty and have a size lower than 252");
        }
        this.allPeerProtocols = peerProtocols.toArray(new PeerProtocol[0]);
    }

    public PeerProtocol getProtocol(int id) throws NegotiationException {
        if (id < 0 || id >= this.allPeerProtocols.length) {
            throw new NegotiationException("not a valid protocol ID: " + id);
        }
        return this.allPeerProtocols[id];
    }

    public PeerProtocol initiateAccepted() {
        this.throwIfNoneInitiated();
        PeerProtocol ret = this.initiatedPeerProtocol;
        this.initiatedPeerProtocol = null;
        return ret;
    }

    public void initiateFailed() {
        this.throwIfNoneInitiated();
        this.initiatedPeerProtocol.initiateFailed();
        this.initiatedPeerProtocol = null;
    }

    public void negotiationExceptionOccurred() {
        if (this.initiatedPeerProtocol != null) {
            this.initiatedPeerProtocol.initiateFailed();
        }
    }

    public PeerProtocol getInitiatedProtocol() {
        this.throwIfNoneInitiated();
        return this.initiatedPeerProtocol;
    }

    public byte initiateProtocol() {
        for (byte i = 0; i < this.allPeerProtocols.length; i = (byte)((byte)(i + 1))) {
            if (!this.allPeerProtocols[i].shouldInitiate()) continue;
            this.initiatedPeerProtocol = this.allPeerProtocols[i];
            return i;
        }
        return -1;
    }

    private void throwIfNoneInitiated() {
        if (this.initiatedPeerProtocol == null) {
            throw new IllegalStateException("no protocol initiated");
        }
    }

    public void cleanup() {
        for (PeerProtocol peerProtocol : this.allPeerProtocols) {
            peerProtocol.cleanup();
        }
    }
}

