/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.common.metrics.extensions.PhaseTimer;
import com.swirlds.common.metrics.extensions.PhaseTimerBuilder;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.event.FutureEventBuffer;
import org.hiero.consensus.event.FutureEventBufferingOption;
import org.hiero.consensus.event.creator.EventCreationConfig;
import org.hiero.consensus.event.creator.EventCreatorModule;
import org.hiero.consensus.event.creator.impl.EventCreationStatus;
import org.hiero.consensus.event.creator.impl.EventCreator;
import org.hiero.consensus.event.creator.impl.rules.AggregateEventCreationRules;
import org.hiero.consensus.event.creator.impl.rules.EventCreationRule;
import org.hiero.consensus.event.creator.impl.rules.MaximumRateRule;
import org.hiero.consensus.event.creator.impl.rules.PlatformHealthRule;
import org.hiero.consensus.event.creator.impl.rules.PlatformStatusRule;
import org.hiero.consensus.event.creator.impl.rules.SyncLagRule;
import org.hiero.consensus.event.creator.impl.tipset.TipsetEventCreator;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.model.transaction.SignatureTransactionCheck;

public class DefaultEventCreator
implements EventCreatorModule {
    private EventCreator creator;
    private EventCreationRule eventCreationRules;
    private PhaseTimer<EventCreationStatus> phase;
    private PlatformStatus platformStatus;
    private Duration unhealthyDuration = Duration.ZERO;
    private FutureEventBuffer futureEventBuffer;
    private double syncRoundLag;

    public void initialize(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull SecureRandom random, @NonNull KeysAndCerts keysAndCerts, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull EventTransactionSupplier transactionSupplier, @NonNull SignatureTransactionCheck signatureTransactionCheck) {
        if (this.creator != null || this.eventCreationRules != null || this.phase != null || this.futureEventBuffer != null) {
            throw new IllegalStateException("EventCreationManager already initialized");
        }
        TipsetEventCreator eventCreator = new TipsetEventCreator(configuration, metrics, time, random, data -> new PlatformSigner(keysAndCerts).sign(data), roster, selfId, transactionSupplier);
        this.initialize(configuration, metrics, time, signatureTransactionCheck, eventCreator);
    }

    public void initialize(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull SignatureTransactionCheck signatureTransactionCheck, @NonNull EventCreator eventCreator) {
        if (this.creator != null || this.eventCreationRules != null || this.phase != null || this.futureEventBuffer != null) {
            throw new IllegalStateException("EventCreationManager already initialized");
        }
        this.creator = Objects.requireNonNull(eventCreator);
        EventCreationConfig config = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        ArrayList<EventCreationRule> rules = new ArrayList<EventCreationRule>();
        rules.add(new MaximumRateRule(configuration, time));
        rules.add(new PlatformStatusRule(this::getPlatformStatus, signatureTransactionCheck));
        rules.add(new PlatformHealthRule(config.maximumPermissibleUnhealthyDuration(), this::getUnhealthyDuration));
        rules.add(new SyncLagRule(config.maxAllowedSyncLag(), this::getSyncRoundLag));
        this.eventCreationRules = AggregateEventCreationRules.of(rules);
        this.futureEventBuffer = new FutureEventBuffer(metrics, FutureEventBufferingOption.EVENT_BIRTH_ROUND, "eventCreator");
        this.phase = new PhaseTimerBuilder(metrics, time, "platform", EventCreationStatus.class).enableFractionalMetrics().setInitialPhase((Enum)EventCreationStatus.IDLE).setMetricsNamePrefix("eventCreation").build();
    }

    @Nullable
    public PlatformEvent maybeCreateEvent() {
        if (!this.eventCreationRules.isEventCreationPermitted()) {
            this.phase.activatePhase((Enum)this.eventCreationRules.getEventCreationStatus());
            return null;
        }
        this.phase.activatePhase((Enum)EventCreationStatus.ATTEMPTING_CREATION);
        PlatformEvent newEvent = this.creator.maybeCreateEvent();
        if (newEvent == null) {
            this.phase.activatePhase((Enum)EventCreationStatus.NO_ELIGIBLE_PARENTS);
        } else {
            this.eventCreationRules.eventWasCreated();
            this.phase.activatePhase((Enum)EventCreationStatus.RATE_LIMITED);
        }
        return newEvent;
    }

    public void registerEvent(@NonNull PlatformEvent event) {
        PlatformEvent nonFutureEvent = this.futureEventBuffer.addEvent(event);
        if (nonFutureEvent != null) {
            this.creator.registerEvent(event);
        }
    }

    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.creator.setEventWindow(eventWindow);
        this.futureEventBuffer.updateEventWindow(eventWindow).forEach(this.creator::registerEvent);
    }

    public void clear() {
        this.creator.clear();
        this.phase.activatePhase((Enum)EventCreationStatus.IDLE);
        this.futureEventBuffer.clear();
        EventWindow eventWindow = EventWindow.getGenesisEventWindow();
        this.futureEventBuffer.updateEventWindow(eventWindow);
    }

    public void updatePlatformStatus(@NonNull PlatformStatus platformStatus) {
        this.platformStatus = Objects.requireNonNull(platformStatus);
    }

    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.unhealthyDuration = Objects.requireNonNull(duration);
    }

    public void reportSyncRoundLag(@NonNull Double lag) {
        this.syncRoundLag = Objects.requireNonNull(lag);
    }

    @NonNull
    private PlatformStatus getPlatformStatus() {
        return this.platformStatus;
    }

    private Duration getUnhealthyDuration() {
        return this.unhealthyDuration;
    }

    public double getSyncRoundLag() {
        return this.syncRoundLag;
    }
}

