/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Hash;

public class StorageSlotKey
implements Comparable<StorageSlotKey> {
    private final Hash slotHash;
    private final Optional<UInt256> slotKey;

    public StorageSlotKey(Hash slotHash, Optional<UInt256> slotKey) {
        this.slotHash = slotHash;
        this.slotKey = slotKey;
    }

    public StorageSlotKey(UInt256 slotKey) {
        this(Hash.hash((Bytes)slotKey), Optional.of(slotKey));
    }

    public Hash getSlotHash() {
        return this.slotHash;
    }

    public Optional<UInt256> getSlotKey() {
        return this.slotKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageSlotKey that = (StorageSlotKey)o;
        return Objects.equals((Object)this.slotHash, (Object)that.slotHash);
    }

    public int hashCode() {
        return Objects.hash(this.slotHash.hashCode());
    }

    public String toString() {
        return String.format("StorageSlotKey{slotHash=%s, slotKey=%s}", new Object[]{this.slotHash, this.slotKey.map(UInt256::toString).orElse("null")});
    }

    @Override
    public int compareTo(@Nonnull StorageSlotKey other) {
        return this.slotHash.compareTo((Bytes)other.slotHash);
    }
}

