/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public enum TransactionType {
    FRONTIER(248),
    ACCESS_LIST(1),
    EIP1559(2),
    BLOB(3);

    private static final Set<TransactionType> ACCESS_LIST_SUPPORTED_TRANSACTION_TYPES;
    private static final EnumSet<TransactionType> LEGACY_FEE_MARKET_TRANSACTION_TYPES;
    private final int typeValue;

    private TransactionType(int typeValue) {
        this.typeValue = typeValue;
    }

    public byte getSerializedType() {
        return (byte)this.typeValue;
    }

    public byte getEthSerializedType() {
        return this == FRONTIER ? (byte)0 : this.getSerializedType();
    }

    public int compareTo(Byte b) {
        return Byte.valueOf(this.getSerializedType()).compareTo(b);
    }

    public static TransactionType of(int serializedTypeValue) {
        return Arrays.stream(new TransactionType[]{FRONTIER, ACCESS_LIST, EIP1559, BLOB}).filter(transactionType -> transactionType.typeValue == serializedTypeValue).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported transaction type %x", serializedTypeValue)));
    }

    public boolean supportsAccessList() {
        return ACCESS_LIST_SUPPORTED_TRANSACTION_TYPES.contains((Object)this);
    }

    public boolean supports1559FeeMarket() {
        return !LEGACY_FEE_MARKET_TRANSACTION_TYPES.contains((Object)this);
    }

    public boolean requiresChainId() {
        return !this.equals((Object)FRONTIER);
    }

    public boolean supportsBlob() {
        return this.equals((Object)BLOB);
    }

    static {
        ACCESS_LIST_SUPPORTED_TRANSACTION_TYPES = Set.of(ACCESS_LIST, EIP1559, BLOB);
        LEGACY_FEE_MARKET_TRANSACTION_TYPES = EnumSet.of(FRONTIER, ACCESS_LIST);
    }
}

